/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.lib;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private static final Map<TypeToken<?>, Class<?>> tokenToRawType = new ConcurrentHashMap();

    public static Class<?> getRawType(TypeToken<?> token) {
        return tokenToRawType.computeIfAbsent(token, t -> t.getRawType());
    }

    public static <T> Stream<T> ofType(Class<? extends T> type, Stream<? super T> stream) {
        return stream.filter(el -> el != null && type.isAssignableFrom(el.getClass())).map(type::cast);
    }

    public static <T> Stream<T> ofType(Class<? extends T> type, Iterable<? super T> iterable) {
        return StreamUtils.ofType(type, StreamSupport.stream(iterable.spliterator(), false));
    }

    public static <T> Stream<T> ofType(TypeToken<T> type, Stream<? super T> stream) {
        return stream.filter(el -> el != null && StreamUtils.getRawType(type).isAssignableFrom(el.getClass())).map(el -> StreamUtils.getRawType(type).cast(el));
    }

    public static <T> Stream<T> ofInterface(Class<? extends T> inter, Stream<?> stream) {
        return stream.filter(el -> el != null && inter.isAssignableFrom(el.getClass())).map(inter::cast);
    }

    public static <T> Stream<T> ofInterface(Class<? extends T> inter, Iterable<?> iterable) {
        return StreamUtils.ofInterface(inter, StreamSupport.stream(iterable.spliterator(), false));
    }
}

