/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.config;

import com.minemaarten.signals.block.BlockSignalBase;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.lib.Log;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Config(modid="signals")
@Mod.EventBusSubscriber(modid="signals")
public class SignalsConfig {
    public static ClientConfig client = new ClientConfig();
    @Config.Name(value="Enable rail network")
    @Config.Comment(value={"ONLY SET TO FALSE IN CASE OF CRASHES. With this set to false, Signals will not work at all!"})
    public static boolean enableRailNetwork = true;
    @Config.Name(value="Cart blacklists")
    @Config.Comment(value={"Useful to disallow carts from Signals interaction. Cart names are how they would be used in a 'summon' command (<modid>:<entityName>)."})
    public static CartBlacklists cartBlacklists = new CartBlacklists();
    @Config.Name(value="Disable chunk load upgrades")
    @Config.Comment(value={"When true, disallows chunk load upgrades to be crafted and used."})
    public static boolean disableChunkLoaderUpgrades;

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("signals")) {
            ConfigManager.sync((String)"signals", (Config.Type)Config.Type.INSTANCE);
            if (!enableRailNetwork) {
                Log.warning("RAIL NETWORK IS NOT FUNCTIONAL!");
            }
        }
    }

    public static class CartBlacklists {
        @Config.Name(value="Cart Engine")
        @Config.Comment(value={"Engines cannot be applied to carts in this config option"})
        public String[] cartEngines = new String[0];

        public static boolean isBlacklisted(EntityMinecart cart, String[] config) {
            if (config.length == 0) {
                return false;
            }
            EntityEntry entry = EntityRegistry.getEntry(cart.getClass());
            ResourceLocation cartID = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entry);
            for (String blacklist : config) {
                if (!cartID.equals((Object)new ResourceLocation(blacklist))) continue;
                return true;
            }
            return false;
        }
    }

    public static enum EnumRenderType {
        SECTION,
        PATHS,
        EDGES;

    }

    public static class NetworkVisualizationSettings {
        @Config.Name(value="Render type")
        public EnumRenderType renderType;
        @Config.Name(value="Render directionality")
        @Config.Comment(value={"Whether or not to render the arrows indicating which way trains can travel in"})
        public boolean renderDirectionality = true;

        public NetworkVisualizationSettings() {
        }

        public NetworkVisualizationSettings(EnumRenderType defaultRenderType) {
            this.renderType = defaultRenderType;
        }
    }

    public static class NetworkVisualization {
        @Config.Name(value="Valid items")
        @Config.Comment(value={"When one of these items is held, the rail network visualization will show."})
        public String[] validItems = new String[0];
        @Config.Name(value="Not sneaking")
        @Config.Comment(value={"What is shown when the player is holding an applicable item, and is not sneaking"})
        public NetworkVisualizationSettings notSneaking = new NetworkVisualizationSettings(EnumRenderType.SECTION);
        @Config.Name(value="Sneaking")
        @Config.Comment(value={"What is shown when the player is holding an applicable item, is sneaking"})
        public NetworkVisualizationSettings sneaking = new NetworkVisualizationSettings(EnumRenderType.PATHS);

        public void initDefaults() {
            if (this.validItems.length == 0) {
                ArrayList<Item> items = new ArrayList<Item>();
                items.add(ModItems.RAIL_CONFIGURATOR);
                items.add(Item.func_150898_a((Block)ModBlocks.RAIL_LINK));
                for (Item item : Item.field_150901_e) {
                    Block block;
                    if (!(item instanceof ItemBlock) || !((block = ((ItemBlock)item).func_179223_d()) instanceof BlockSignalBase) && !(block instanceof BlockRailBase)) continue;
                    items.add(item);
                }
                this.validItems = new String[items.size()];
                for (int i = 0; i < items.size(); ++i) {
                    this.validItems[i] = ((ResourceLocation)Item.field_150901_e.func_177774_c(items.get(i))).toString();
                }
            }
        }

        public boolean isValid(Item item) {
            String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).toString();
            for (String validItem : this.validItems) {
                if (!validItem.equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ClientConfig {
        @Config.Name(value="Network visualization")
        public NetworkVisualization networkVisualization = new NetworkVisualization();
    }
}

