/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.render.signals;

import com.google.common.collect.ImmutableList;
import com.minemaarten.signals.client.BakedRenderer;
import com.minemaarten.signals.client.render.signals.AbstractRailRenderer;
import com.minemaarten.signals.lib.HeadingUtils;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailEdge;
import com.minemaarten.signals.rail.network.mc.MCNetworkRail;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class DirectionalityRenderer {
    private TIntObjectHashMap<BakedRenderer> bakedRenderers = new TIntObjectHashMap();

    public void render(int dimensionID, BufferBuilder b) {
        BakedRenderer bakedRenderer = (BakedRenderer)this.bakedRenderers.get(dimensionID);
        if (bakedRenderer != null) {
            b.func_181668_a(4, DefaultVertexFormats.field_181705_e);
            bakedRenderer.render(b);
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public void updateRender() {
        TIntObjectHashMap bakedRenderers = new TIntObjectHashMap();
        for (RailEdge<MCPos> edge : RailNetworkManager.getServerInstance().getNetwork().getAllEdges()) {
            if (edge.directionality.canTravelForwards) {
                this.build((TIntObjectHashMap<BakedRenderer>)bakedRenderers, edge.edge);
            }
            if (!edge.directionality.canTravelBackwards) continue;
            this.build((TIntObjectHashMap<BakedRenderer>)bakedRenderers, (ImmutableList<NetworkRail<MCPos>>)edge.edge.reverse());
        }
        this.bakedRenderers = bakedRenderers;
    }

    private void build(TIntObjectHashMap<BakedRenderer> bakedRenderers, ImmutableList<NetworkRail<MCPos>> edge) {
        for (int edgeIndex = 1; edgeIndex < edge.size() - 1; ++edgeIndex) {
            NetworkRail prevRail = (NetworkRail)edge.get(edgeIndex - 1);
            MCNetworkRail curRail = (MCNetworkRail)edge.get(edgeIndex);
            NetworkRail nextRail = (NetworkRail)edge.get(edgeIndex + 1);
            EnumHeading prevHeading = ((MCPos)curRail.getPos()).getRelativeHeading((MCPos)prevRail.getPos());
            EnumHeading nextHeading = ((MCPos)nextRail.getPos()).getRelativeHeading((MCPos)curRail.getPos());
            if (prevHeading == null || nextHeading == null || prevHeading != nextHeading || ((MCPos)curRail.getPos()).getDimID() != ((MCPos)nextRail.getPos()).getDimID() || ((MCPos)curRail.getPos()).getDimID() != ((MCPos)prevRail.getPos()).getDimID()) continue;
            BakedRenderer bakedRenderer = (BakedRenderer)bakedRenderers.get(((MCPos)curRail.getPos()).getDimID());
            if (bakedRenderer == null) {
                bakedRenderer = new BakedRenderer();
                bakedRenderers.put(((MCPos)curRail.getPos()).getDimID(), (Object)bakedRenderer);
            }
            MCPos pos = (MCPos)curRail.getPos();
            EnumFacing facing = HeadingUtils.toFacing(nextHeading).func_176734_d();
            EnumFacing rotatedFacing = facing.func_176746_e();
            EnumFacing rotatedFacing2 = facing.func_176735_f();
            int yOffset = AbstractRailRenderer.getRailHeightOffset(curRail, facing);
            Vec3d posVec = new Vec3d((double)pos.getX() + 0.5, (double)pos.getY() + (yOffset != 0 ? 0.6001 : 0.1001), (double)pos.getZ() + 0.5);
            double arrowSize = 0.1;
            double spacing = 0.1;
            for (int i = -2; i < -1; ++i) {
                Vec3d shiftedPosVec = posVec.func_72441_c((double)facing.func_82601_c() * spacing * (double)i, spacing * (double)i * (double)yOffset + 0.001, (double)facing.func_82599_e() * spacing * (double)i);
                Vec3d vecBack = shiftedPosVec.func_72441_c((double)facing.func_82601_c() * arrowSize, arrowSize * (double)yOffset, (double)facing.func_82599_e() * arrowSize);
                Vec3d c1 = vecBack.func_72441_c((double)rotatedFacing.func_82601_c() * arrowSize, 0.0, (double)rotatedFacing.func_82599_e() * arrowSize);
                Vec3d c2 = vecBack.func_72441_c((double)rotatedFacing2.func_82601_c() * arrowSize, 0.0, (double)rotatedFacing2.func_82599_e() * arrowSize);
                bakedRenderer.add(shiftedPosVec.field_72450_a, shiftedPosVec.field_72448_b, shiftedPosVec.field_72449_c);
                bakedRenderer.add(c1.field_72450_a, c1.field_72448_b, c1.field_72449_c);
                bakedRenderer.add(c2.field_72450_a, c2.field_72448_b, c2.field_72449_c);
            }
        }
    }
}

