/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.gui;

import com.minemaarten.signals.api.access.IDestinationAccessor;
import com.minemaarten.signals.client.gui.GuiContainerBase;
import com.minemaarten.signals.client.gui.widget.IGuiWidget;
import com.minemaarten.signals.client.gui.widget.WidgetComboBox;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import java.awt.Point;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;

public abstract class GuiDestinations<DestinationAccessor extends IDestinationAccessor>
extends GuiContainerBase<TileEntity> {
    private WidgetComboBox[] stationNameFields;
    protected final DestinationAccessor destinationAccessor;

    public GuiDestinations(Container container, DestinationAccessor destinationAccessor) {
        super(container, null, null);
        this.destinationAccessor = destinationAccessor;
        this.field_147000_g = 200;
        this.field_146999_f = 120;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        WidgetComboBox[] oldFields = this.stationNameFields;
        this.stationNameFields = new WidgetComboBox[this.destinationAccessor.getTotalDestinations() + 1];
        for (i = 0; i < this.stationNameFields.length; ++i) {
            this.stationNameFields[i] = new WidgetComboBox(this.field_146289_q, this.field_147003_i + 10, this.field_146295_m / 2 - 5 - this.stationNameFields.length * 7 + i * 14, 100, this.field_146289_q.field_78288_b);
            this.stationNameFields[i].setElements(RailNetworkManager.getClientInstance().getNetwork().getStationNames());
            this.addWidget(this.stationNameFields[i]);
        }
        if (oldFields != null) {
            for (i = 0; i < oldFields.length && i < this.stationNameFields.length; ++i) {
                if (oldFields[i].func_146206_l()) {
                    this.stationNameFields[i].func_146180_a(oldFields[i].func_146179_b());
                }
                this.stationNameFields[i].func_146195_b(oldFields[i].func_146206_l());
            }
        }
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    protected boolean showDestination() {
        return true;
    }

    @Override
    protected void func_146976_a(float partialTicks, int i, int j) {
        this.drawBackLayer();
        if (this.showDestination()) {
            String dest = this.destinationAccessor.getCurrentDestination();
            if (dest.equals("")) {
                this.drawDarkGreyTextCentered(this.field_147003_i + 60, this.field_147009_r + this.field_147000_g - 18, "signals.gui.cart.no_destination", new Object[0]);
            } else {
                this.drawDarkGreyTextCentered(this.field_147003_i + 60, this.field_147009_r + this.field_147000_g - 18, "signals.gui.cart.destination", dest);
            }
        }
        if (this.destinationAccessor.getTotalDestinations() > 0) {
            if (this.showDestination()) {
                this.drawDestinationRect(this.destinationAccessor.getDestinationIndex(), -16755456);
            }
            for (int invalidDest : this.destinationAccessor.getInvalidDestinationIndeces()) {
                this.drawDestinationRect(invalidDest, -1426128896);
            }
        }
        super.func_146976_a(partialTicks, i, j);
    }

    private void drawDestinationRect(int destinationIndex, int color) {
        int indicatorX = this.field_147003_i + 7;
        int indicatorY = this.field_146295_m / 2 - this.stationNameFields.length * 7 + destinationIndex * 14 - 8;
        GuiDestinations.func_73734_a((int)indicatorX, (int)indicatorY, (int)(indicatorX + 106), (int)(indicatorY + this.field_146289_q.field_78288_b + 6), (int)color);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        String[] destinations = this.destinationAccessor.getDestinations();
        for (int i = 0; i < this.stationNameFields.length; ++i) {
            if (this.stationNameFields[i].func_146206_l()) continue;
            this.stationNameFields[i].func_146180_a(i < destinations.length ? destinations[i] : "");
        }
        if (this.destinationAccessor.getTotalDestinations() != this.stationNameFields.length - 1) {
            this.scheduleRefresh();
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        super.onKeyTyped(widget);
        this.destinationAccessor.setDestinations(this.getDestinations());
    }

    private List<String> getDestinations() {
        return Stream.of(this.stationNameFields).map(widget -> widget.func_146179_b()).collect(Collectors.toList());
    }
}

