/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.capabilities;

import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.api.access.IDestinationAccessor;
import com.minemaarten.signals.api.access.ISignal;
import com.minemaarten.signals.chunkloading.ChunkLoadManager;
import com.minemaarten.signals.config.SignalsConfig;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.inventory.EngineItemHandler;
import com.minemaarten.signals.lib.Log;
import com.minemaarten.signals.lib.SignalsUtils;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSpawnParticle;
import com.minemaarten.signals.network.PacketUpdateMinecartEngineState;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.mc.MCNetworkState;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.IGUITextFieldSensitive;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CapabilityMinecartDestination
implements IGUITextFieldSensitive,
IDestinationAccessor {
    @CapabilityInject(value=CapabilityMinecartDestination.class)
    public static Capability<CapabilityMinecartDestination> INSTANCE;
    private static final Pattern EMPTY_PATTERN;
    @GuiSynced
    private String destinationStations = "";
    private Pattern[] destinationRegexes = new Pattern[0];
    @GuiSynced
    private int curDestinationIndex;
    @GuiSynced
    private String invalidDestinations = "";
    private boolean chunkloading;
    private String chunkloadingPlayer = "";
    private boolean motorized;
    @GuiSynced
    private int fuelLeft;
    @GuiSynced
    private int totalBurnTime;
    private int hopperTimer;
    private final InventoryBasic fuelInv = new InventoryBasic("cartEngineInv", true, 5){

        public boolean func_94041_b(int index, ItemStack stack) {
            return stack == null || TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
    };
    private final IItemHandler fuelItemHandler = new InvWrapper((IInventory)this.fuelInv);
    private final IItemHandler engineItemHandler = new EngineItemHandler(this, this.fuelItemHandler);
    private boolean motorActive;
    public boolean travelingBetweenDimensions;

    public static void register() {
        CapabilityManager.INSTANCE.register(CapabilityMinecartDestination.class, (Capability.IStorage)new Capability.IStorage<CapabilityMinecartDestination>(){

            public NBTBase writeNBT(Capability<CapabilityMinecartDestination> capability, CapabilityMinecartDestination instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("destinations", instance.destinationStations);
                tag.func_74768_a("destIndex", instance.curDestinationIndex);
                tag.func_74757_a("chunkloading", instance.chunkloading);
                tag.func_74778_a("chunkloadingPlayer", instance.chunkloadingPlayer);
                tag.func_74757_a("motorized", instance.motorized);
                if (instance.motorized) {
                    tag.func_74768_a("fuelLeft", instance.fuelLeft);
                    tag.func_74768_a("totalBurnTime", instance.totalBurnTime);
                    SignalsUtils.writeInventoryToNBT(tag, (IInventory)instance.fuelInv);
                }
                return tag;
            }

            public void readNBT(Capability<CapabilityMinecartDestination> capability, CapabilityMinecartDestination instance, EnumFacing side, NBTBase base) {
                NBTTagCompound tag = (NBTTagCompound)base;
                instance.destinationStations = tag.func_74779_i("destinations");
                instance.recompileRegexes();
                instance.curDestinationIndex = tag.func_74762_e("destIndex");
                instance.chunkloading = tag.func_74767_n("chunkloading");
                instance.chunkloadingPlayer = tag.func_74779_i("chunkloadingPlayer");
                instance.motorized = tag.func_74767_n("motorized");
                if (instance.motorized) {
                    instance.fuelLeft = tag.func_74762_e("fuelLeft");
                    instance.totalBurnTime = tag.func_74762_e("totalBurnTime");
                    SignalsUtils.readInventoryFromNBT(tag, (IInventory)instance.fuelInv);
                }
            }
        }, CapabilityMinecartDestination::new);
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.destinationStations = text;
        this.recompileRegexes();
    }

    @Override
    public void setDestinations(String ... destinations) {
        Validate.noNullElements((Object[])destinations, (String)"The destinations array contains null at position %d", (Object[])new Object[0]);
        this.destinationStations = StringUtils.joinWith((String)"\n", (Object[])destinations);
        this.recompileRegexes();
    }

    private void recompileRegexes() {
        String[] destinations = this.getDestinations();
        this.destinationRegexes = new Pattern[destinations.length];
        this.invalidDestinations = "";
        for (int i = 0; i < destinations.length; ++i) {
            try {
                this.destinationRegexes[i] = Pattern.compile(destinations[i]);
                continue;
            }
            catch (PatternSyntaxException e) {
                if (!this.invalidDestinations.equals("")) {
                    this.invalidDestinations = this.invalidDestinations + ",";
                }
                this.invalidDestinations = this.invalidDestinations + "" + i;
                this.destinationRegexes[i] = EMPTY_PATTERN;
            }
        }
        this.getCurrentDestination();
    }

    @Override
    public int[] getInvalidDestinationIndeces() {
        if (this.invalidDestinations.equals("")) {
            return new int[0];
        }
        String[] strings = this.invalidDestinations.split(",");
        int[] ints = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ints[i] = Integer.parseInt(strings[i]);
        }
        return ints;
    }

    @Override
    public String getText(int textFieldID) {
        return this.destinationStations;
    }

    public String getDestination(int index) {
        return this.getDestinations()[index];
    }

    @Override
    public String[] getDestinations() {
        return this.destinationStations.equals("") ? new String[]{} : this.destinationStations.split("\n");
    }

    @Override
    public int getTotalDestinations() {
        return this.getDestinations().length;
    }

    @Override
    public String getCurrentDestination() {
        String[] destinations = this.getDestinations();
        if (this.curDestinationIndex >= destinations.length || this.curDestinationIndex == -1) {
            this.nextDestination();
        }
        return this.curDestinationIndex >= 0 ? destinations[this.curDestinationIndex] : "";
    }

    @Override
    public int getDestinationIndex() {
        this.getCurrentDestination();
        return this.curDestinationIndex;
    }

    public void nextDestination() {
        this.setCurrentDestinationIndex(this.curDestinationIndex + 1);
    }

    @Override
    public void setCurrentDestinationIndex(int index) {
        String[] destinations = this.getDestinations();
        this.curDestinationIndex = index >= destinations.length || index < 0 ? (destinations.length > 0 ? 0 : -1) : index;
    }

    public Pattern getCurrentDestinationRegex() {
        this.getCurrentDestination();
        return this.curDestinationIndex >= 0 ? this.destinationRegexes[this.curDestinationIndex] : EMPTY_PATTERN;
    }

    public boolean setChunkloading(EntityPlayer associatedPlayer, EntityMinecart cart) {
        this.chunkloadingPlayer = associatedPlayer.func_146103_bH().getId().toString();
        if (ChunkLoadManager.INSTANCE.markAsChunkLoader(associatedPlayer, cart)) {
            this.chunkloading = true;
            return true;
        }
        return false;
    }

    public boolean isChunkLoading() {
        return this.chunkloading;
    }

    public void setMotorized() {
        this.motorized = true;
    }

    public boolean isMotorized() {
        return this.motorized;
    }

    public boolean useFuel(EntityMinecart cart) {
        if (this.motorized) {
            if (this.fuelLeft == 0) {
                for (int i = 0; i < this.fuelInv.func_70302_i_(); ++i) {
                    int fuelValue;
                    ItemStack fuel = this.fuelInv.func_70301_a(i);
                    if (fuel.func_190926_b() || (fuelValue = TileEntityFurnace.func_145952_a((ItemStack)fuel)) <= 0) continue;
                    fuel.func_190918_g(1);
                    if (fuel.func_190926_b()) {
                        this.fuelInv.func_70299_a(i, fuel.func_77973_b().getContainerItem(fuel));
                    }
                    this.fuelLeft += fuelValue;
                    this.totalBurnTime = fuelValue;
                    break;
                }
            }
            if (this.fuelLeft > 0) {
                --this.fuelLeft;
                double randX = cart.func_174791_d().field_72450_a + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                double randY = cart.func_174791_d().field_72448_b + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                double randZ = cart.func_174791_d().field_72449_c + (cart.field_70170_p.field_73012_v.nextDouble() - 0.5) * 0.5;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, randX, randY, randZ, 0.0, 0.0, 0.0), cart.field_70170_p);
                return true;
            }
        }
        return false;
    }

    public InventoryBasic getFuelInv() {
        return this.fuelInv;
    }

    public IItemHandler getEngineItemHandler() {
        return this.motorized ? this.fuelItemHandler : this.engineItemHandler;
    }

    public int getScaledFuel(int barLength) {
        return this.totalBurnTime == 0 ? 0 : barLength * this.fuelLeft / this.totalBurnTime;
    }

    public void onCartBroken(EntityMinecart cart) {
        if (!this.travelingBetweenDimensions && this.motorized) {
            this.motorized = false;
            cart.func_145779_a(ModItems.CART_ENGINE, 1);
            for (int i = 0; i < this.fuelInv.func_70302_i_(); ++i) {
                ItemStack fuel = this.fuelInv.func_70301_a(i);
                if (fuel == null) continue;
                cart.func_70099_a(fuel, 0.0f);
            }
        }
        if (this.chunkloading) {
            ChunkLoadManager.INSTANCE.unmarkAsChunkLoader(cart);
            if (!this.travelingBetweenDimensions) {
                this.chunkloading = false;
                if (!SignalsConfig.disableChunkLoaderUpgrades) {
                    cart.func_145779_a(ModItems.CHUNKLOADER_UPGRADE, 1);
                }
            }
        }
        this.travelingBetweenDimensions = false;
    }

    public void onCartJoinWorld(EntityMinecart cart) {
        if (this.chunkloading && !ChunkLoadManager.INSTANCE.markAsChunkLoader(this.chunkloadingPlayer, cart)) {
            Log.warning("Could not chunkload cart for player '" + this.chunkloadingPlayer + "'!");
        }
    }

    public void setEngineActive(boolean active) {
        this.motorActive = active;
    }

    public void onCartUpdate(MinecartUpdateEvent event) {
        EntityMinecart cart = event.getMinecart();
        if (!cart.field_70170_p.field_72995_K) {
            if (this.isMotorized()) {
                boolean shouldRun = true;
                EnumFacing cartDir = cart.func_184172_bi();
                Vec3d vec3d = new Vec3d(cart.field_70159_w, cart.field_70181_x, cart.field_70179_y);
                if (vec3d.func_72433_c() < 0.05) {
                    shouldRun = false;
                    if (this.hopperTimer > 0) {
                        --this.hopperTimer;
                    }
                    if (this.hopperTimer == 0) {
                        this.hopperTimer = this.extractFuelFromHopper(cart, event.getPos()) ? 8 : 40;
                    }
                } else {
                    this.hopperTimer = 0;
                    NetworkRail<MCPos> rail = RailNetworkManager.getInstance(cart.field_70170_p.field_72995_K).getRail(cart.field_70170_p, event.getPos());
                    if (rail == null) {
                        IBlockState state = cart.field_70170_p.func_180495_p(event.getPos());
                        IRail r = RailManager.getInstance().getRail(cart.field_70170_p, event.getPos(), state);
                        shouldRun = r != null;
                    } else {
                        RailNetwork<MCPos> network = RailNetworkManager.getInstance(cart.field_70170_p.field_72995_K).getNetwork();
                        NetworkSignal signal = network.railObjects.getNeighborSignals(rail.getPotentialNeighborObjectLocations()).filter(s -> ((MCPos)s.getRailPos()).equals(rail.getPos())).findFirst().orElse(null);
                        MCNetworkState state = RailNetworkManager.getInstance(cart.field_70170_p.field_72995_K).getState();
                        boolean bl = shouldRun = signal == null || state.getLampStatus((IPosition)signal.getPos()) == ISignal.EnumLampStatus.GREEN;
                        if (!shouldRun) {
                            cart.field_70159_w = 0.0;
                            cart.field_70179_y = 0.0;
                        }
                    }
                }
                if (shouldRun && this.useFuel(cart)) {
                    if (!this.motorActive) {
                        NetworkHandler.sendToAllAround(new PacketUpdateMinecartEngineState(cart, true), new NetworkRegistry.TargetPoint(cart.field_70170_p.field_73011_w.getDimension(), cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 64.0));
                    }
                    this.motorActive = true;
                    double acceleration = 0.03;
                    cart.field_70159_w += (double)cartDir.func_82601_c() * acceleration;
                    cart.field_70179_y += (double)cartDir.func_82599_e() * acceleration;
                    cart.field_70159_w = MathHelper.func_151237_a((double)cart.field_70159_w, (double)(-cart.getMaxCartSpeedOnRail()), (double)cart.getMaxCartSpeedOnRail());
                    cart.field_70179_y = MathHelper.func_151237_a((double)cart.field_70179_y, (double)(-cart.getMaxCartSpeedOnRail()), (double)cart.getMaxCartSpeedOnRail());
                } else {
                    if (this.motorActive) {
                        NetworkHandler.sendToAllAround(new PacketUpdateMinecartEngineState(cart, true), new NetworkRegistry.TargetPoint(cart.field_70170_p.field_73011_w.getDimension(), cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 64.0));
                    }
                    this.motorActive = false;
                }
            }
            if (this.chunkloading) {
                double x = cart.field_70165_t + cart.field_70170_p.field_73012_v.nextDouble() - 0.5;
                double y = cart.field_70163_u + cart.field_70170_p.field_73012_v.nextDouble() - 0.5;
                double z = cart.field_70161_v + cart.field_70170_p.field_73012_v.nextDouble() - 0.5;
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.PORTAL, x, y, z, 0.0, 0.0, 0.0), cart.field_70170_p);
                if (SignalsConfig.disableChunkLoaderUpgrades) {
                    ChunkLoadManager.INSTANCE.unmarkAsChunkLoader(cart);
                    this.chunkloading = false;
                }
            }
        } else if (this.motorActive) {
            cart.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, cart.func_174791_d().field_72450_a, cart.func_174791_d().field_72448_b, cart.func_174791_d().field_72449_c, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean extractFuelFromHopper(EntityMinecart cart, BlockPos pos) {
        boolean foundHopper = false;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos neighbor = pos;
            for (int offsetTimes = 0; offsetTimes < (dir == EnumFacing.UP ? 2 : 1); ++offsetTimes) {
                EnumFacing hopperDir;
                TileEntity te = cart.field_70170_p.func_175625_s(neighbor = neighbor.func_177972_a(dir));
                if (!(te instanceof TileEntityHopper) || (hopperDir = (EnumFacing)cart.field_70170_p.func_180495_p(neighbor).func_177229_b((IProperty)BlockHopper.field_176430_a)).func_176734_d() != dir) continue;
                TileEntityHopper hopper = (TileEntityHopper)te;
                for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                    ItemStack stack = hopper.func_70301_a(i);
                    if (stack.func_190926_b() || !this.getFuelInv().func_94041_b(0, stack)) continue;
                    ItemStack inserted = stack.func_77946_l();
                    inserted.func_190920_e(1);
                    ItemStack left = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getEngineItemHandler(), (ItemStack)inserted, (boolean)false);
                    if (!left.func_190926_b()) continue;
                    stack.func_190918_g(1);
                    hopper.func_70296_d();
                    return true;
                }
                foundHopper = true;
            }
        }
        return foundHopper;
    }

    static {
        EMPTY_PATTERN = Pattern.compile("");
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private final CapabilityMinecartDestination cap = new CapabilityMinecartDestination();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == INSTANCE;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)this.cap;
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return INSTANCE.getStorage().writeNBT(INSTANCE, (Object)this.cap, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            INSTANCE.getStorage().readNBT(INSTANCE, (Object)this.cap, null, nbt);
        }
    }
}

