/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.util.EntityOpacityHandler;
import vazkii.quark.oddities.feature.TinyPotato;
import vazkii.quark.tweaks.ai.EntityAIWantLove;
import vazkii.quark.world.entity.ai.EntityAIFoxhoundSleep;
import vazkii.quark.world.entity.ai.EntityAISleep;
import vazkii.quark.world.feature.Foxhounds;

public class EntityFoxhound
extends EntityWolf
implements IMob {
    public static final ResourceLocation FOXHOUND_LOOT_TABLE = new ResourceLocation("quark", "entities/foxhound");
    private static final DataParameter<Boolean> TEMPTATION = EntityDataManager.func_187226_a(EntityFoxhound.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityFoxhound.class, (DataSerializer)DataSerializers.field_187198_h);
    private int timeUntilPotatoEmerges = 0;
    protected EntityAISleep aiSleep;

    public EntityFoxhound(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 0.8f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 1.0f);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_175547_a(EnumDyeColor.ORANGE);
        this.field_70180_af.func_187214_a(TEMPTATION, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
    }

    public boolean func_104002_bU() {
        return this.func_70909_n() || super.func_104002_bU();
    }

    public boolean func_70094_T() {
        return EntityOpacityHandler.isEntityInsideOpaqueBlock((Entity)this);
    }

    public void func_70636_d() {
        List foxhounds;
        int cookTime;
        BlockPos below;
        TileEntity tile;
        EntityLivingBase owner;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && !this.func_70909_n()) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && TinyPotato.tiny_potato != null) {
            if (this.timeUntilPotatoEmerges == 1) {
                this.timeUntilPotatoEmerges = 0;
                ItemStack stack = new ItemStack((Block)TinyPotato.tiny_potato);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"angery", (boolean)true);
                this.func_70099_a(stack, 0.0f);
                this.func_184185_a(SoundEvents.field_187543_bD, 1.0f, 1.0f);
            } else if (this.timeUntilPotatoEmerges > 1) {
                --this.timeUntilPotatoEmerges;
            }
        }
        if (!(!EntityAIWantLove.needsPets((EntityTameable)this) || (owner = this.func_70902_q()) == null || !(owner.func_70068_e((Entity)this) < 1.0) || owner.func_70090_H() || owner.func_70045_F() || owner instanceof EntityPlayer && ((EntityPlayer)owner).func_184812_l_())) {
            owner.func_70015_d(5);
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(this.isSleeping() ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.func_70909_n() && (tile = this.field_70170_p.func_175625_s(below = this.func_180425_c().func_177977_b())) instanceof TileEntityFurnace && (cookTime = ((TileEntityFurnace)tile).func_174887_a_(2)) > 0 && cookTime % 3 == 0 && !(foxhounds = this.field_70170_p.func_175647_a(EntityFoxhound.class, new AxisAlignedBB(this.func_180425_c()), fox -> fox != null && fox.func_70909_n())).isEmpty() && foxhounds.get(0) == this) {
            ((TileEntityFurnace)tile).func_174885_b(2, Math.min(199, cookTime + 1));
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return FOXHOUND_LOOT_TABLE;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiSleep = new EntityAISleep(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiSleep);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFoxhoundSleep(this, 0.8, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFoxhoundSleep(this, 0.8, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIBeg((EntityWolf)this, 8.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, target -> target instanceof EntitySheep || target instanceof EntityRabbit));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityPlayer.class, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractSkeleton.class, false));
    }

    public boolean func_70919_bu() {
        return !this.func_70909_n() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL || super.func_70919_bu();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_70045_F()) {
            if (entityIn instanceof EntityPlayer) {
                return false;
            }
            return super.func_70652_k(entityIn);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76361_j(), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            entityIn.func_70015_d(5);
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        this.setWoke();
        return super.func_70097_a(source, amount);
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151103_aS && !this.func_70909_n()) {
            return false;
        }
        if (!(this.func_70909_n() || itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151044_h || this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && !player.func_184812_l_() && player.func_70660_b(MobEffects.field_76426_n) == null || this.field_70170_p.field_72995_K)) {
            if (this.field_70146_Z.nextDouble() < Foxhounds.tameChance) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.func_70606_j(20.0f);
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.func_70908_e(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)TinyPotato.tiny_potato)) {
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 0.5f + (float)Math.random() * 0.5f);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.timeUntilPotatoEmerges = 1201;
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setWoke();
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return super.func_70878_b(otherAnimal) && otherAnimal instanceof EntityFoxhound;
    }

    public EntityWolf func_90011_a(EntityAgeable otherParent) {
        EntityFoxhound entitywolf = new EntityFoxhound(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitywolf.func_184754_b(uuid);
            entitywolf.func_70903_f(true);
        }
        return entitywolf;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("OhLawdHeComin", this.timeUntilPotatoEmerges);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timeUntilPotatoEmerges = compound.func_74762_e("OhLawdHeComin");
    }

    protected SoundEvent func_184639_G() {
        return this.isSleeping() ? null : super.func_184639_G();
    }

    public boolean isSleeping() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) return false;
        if (!this.isValidLightLevel()) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        if (!iblockstate.func_189884_a((Entity)this)) return false;
        return true;
    }

    public EntityAISleep getAISleep() {
        return this.aiSleep;
    }

    private void setWoke() {
        EntityAISleep sleep = this.getAISleep();
        if (sleep != null) {
            this.setSleeping(false);
            sleep.setSleeping(false);
        }
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f - this.field_70170_p.func_175724_o(pos);
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        int i = this.field_70170_p.func_175671_l(blockpos);
        return i < 8;
    }
}

