/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.block;

import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import vazkii.arl.item.ItemModBlock;
import vazkii.quark.base.block.BlockQuarkBush;
import vazkii.quark.world.world.tree.WorldGenSakuraTree;
import vazkii.quark.world.world.tree.WorldGenSwampTree;

public class BlockVariantSapling
extends BlockQuarkBush
implements IGrowable {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variant.class);
    public static final PropertyInteger STAGE = BlockSapling.field_176479_b;
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    private static final String[] VARIANTS = new String[]{"swamp_sapling", "sakura_sapling"};

    public BlockVariantSapling() {
        super("variant_sapling", VARIANTS);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Variant.SWAMP_SAPLING)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    @Override
    public ItemBlock createItemInstance(ResourceLocation regName) {
        return new ItemModBlock((Block)this, regName){

            public int getItemBurnTime(ItemStack itemStack) {
                return 100;
            }
        };
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object generator = state.func_177229_b(VARIANT) == Variant.SWAMP_SAPLING ? new WorldGenSwampTree(false) : new WorldGenSakuraTree(true);
        worldIn.func_175698_g(pos);
        if (!generator.func_180709_b(worldIn, rand, pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variant.values()[meta & 1])).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal() & 1;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public int func_180651_a(IBlockState state) {
        return ((Variant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, STAGE});
    }

    @Override
    public IProperty getVariantProp() {
        return VARIANT;
    }

    @Override
    public Class getVariantEnum() {
        return Variant.class;
    }

    @Override
    public IProperty[] getIgnoredProperties() {
        return new IProperty[]{STAGE};
    }

    public boolean useBlockstateForItem() {
        return false;
    }

    private static enum Variant implements IStringSerializable
    {
        SWAMP_SAPLING,
        SAKURA_SAPLING;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

