package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class MM_Ghastly extends MobModifier
{

    public MM_Ghastly()
    {
        super();
    }

    public MM_Ghastly(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Ghastly";
    }

    private long nextAbilityUse = 0L;
    private final static long coolDown = 6000L;
    private final static float MIN_DISTANCE = 3F;

    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (hasSteadyTarget()) {
            long time = System.currentTimeMillis();
            if (time > nextAbilityUse)
            {
                nextAbilityUse = time + coolDown;
                tryAbility(mob, mob.field_70170_p.func_72890_a(mob, 12f));
            }
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target)
    {
        if (target == null || !mob.func_70685_l(target))
        {
            return;
        }

        if (mob.func_70032_d(target) > MIN_DISTANCE)
        {
            double diffX = target.field_70165_t - mob.field_70165_t;
            double diffY = target.func_174813_aQ().field_72338_b + (double) (target.field_70131_O / 2.0F) - (mob.field_70163_u + (double) (mob.field_70131_O / 2.0F));
            double diffZ = target.field_70161_v - mob.field_70161_v;
            mob.field_70761_aq = mob.field_70177_z = -((float) Math.atan2(diffX, diffZ)) * 180.0F / (float) Math.PI;

            mob.field_70170_p.func_180498_a(null, 1008, new BlockPos((int) mob.field_70165_t, (int) mob.field_70163_u, (int) mob.field_70161_v), 0);
            EntityLargeFireball entFB = new EntityLargeFireball(mob.field_70170_p, mob, diffX, diffY, diffZ);
            double spawnOffset = 2.0D;
            Vec3d mobLook = mob.func_70676_i(1.0F);
            entFB.field_70165_t = mob.field_70165_t + mobLook.field_72450_a * spawnOffset;
            entFB.field_70163_u = mob.field_70163_u + (double) (mob.field_70131_O / 2.0F) + 0.5D;
            entFB.field_70161_v = mob.field_70161_v + mobLook.field_72449_c * spawnOffset;
            mob.field_70170_p.func_72838_d(entFB);
        }
    }

    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }

    private static String[] suffix = { "OMFGFIREBALLS", "theBomber", "ofBallsofFire" };

    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }

    private static String[] prefix = { "bombing", "fireballsy" };

}
