package atomicstryker.infernalmobs.client;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.Nullable;

import org.lwjgl.opengl.GL11;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class InfernalMobsClient implements ISidedProxy
{
    private final double NAME_VISION_DISTANCE = 32D;
    private Minecraft mc;
    private World lastWorld;
    private long nextPacketTime;
    private ConcurrentHashMap<EntityLivingBase, MobModifier> rareMobsClient;
    private int airOverrideValue = -999;
    private long airDisplayTimeout;

    private long healthBarRetainTime;
    private EntityLivingBase retainedTarget;

    @Override
    public void preInit()
    {
        MinecraftForge.EVENT_BUS.register(this);
        mc = FMLClientHandler.instance().getClient();
    }

    @Override
    public void load()
    {
        nextPacketTime = 0;
        rareMobsClient = new ConcurrentHashMap<>();

        MinecraftForge.EVENT_BUS.register(new RendererBossGlow());
        MinecraftForge.EVENT_BUS.register(this);

        healthBarRetainTime = 0;
        retainedTarget = null;
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event)
    {
        if (event.getWorld().field_72995_K && mc.field_71439_g != null && (event.getEntity() instanceof EntityMob || (event.getEntity() instanceof EntityLivingBase && event.getEntity() instanceof IMob)))
        {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(mc.field_71439_g.func_70005_c_(), event.getEntity().func_145782_y(), (byte) 0));
        }
    }

    private void askServerHealth(Entity ent)
    {
        if (System.currentTimeMillis() > nextPacketTime)
        {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(mc.field_71439_g.func_70005_c_(), ent.func_145782_y(), 0f, 0f));
            nextPacketTime = System.currentTimeMillis() + 100L;
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event)
    {
        if (InfernalMobsCore.instance().getIsHealthBarDisabled() || event.getType() != RenderGameOverlayEvent.ElementType.BOSSHEALTH || mc.field_71456_v.func_184046_j().func_184054_d())
        {
            return;
        }

        Entity ent = getEntityCrosshairOver(event.getPartialTicks(), mc);
        boolean retained = false;

        if (ent == null && System.currentTimeMillis() < healthBarRetainTime)
        {
            ent = retainedTarget;
            retained = true;
        }

        if (ent != null && ent instanceof EntityLivingBase)
        {
            MobModifier mod = InfernalMobsCore.getMobModifiers((EntityLivingBase) ent);
            if (mod != null)
            {
                askServerHealth(ent);

                GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GL11.glDisable(GL11.GL_BLEND);

                EntityLivingBase target = (EntityLivingBase) ent;
                String buffer = mod.getEntityDisplayName(target);

                ScaledResolution resolution = new ScaledResolution(mc);
                int screenwidth = resolution.func_78326_a();
                FontRenderer fontR = mc.field_71466_p;

                GuiIngame gui = mc.field_71456_v;
                short lifeBarLength = 182;
                int x = screenwidth / 2 - lifeBarLength / 2;

                int lifeBarLeft = (int) (mod.getActualHealth(target) / mod.getActualMaxHealth(target) * (float) (lifeBarLength + 1));
                byte y = 12;
                gui.func_73729_b(x, y, 0, 74, lifeBarLength, 5);
                gui.func_73729_b(x, y, 0, 74, lifeBarLength, 5);

                if (lifeBarLeft > 0)
                {
                    gui.func_73729_b(x, y, 0, 79, lifeBarLeft, 5);
                }

                int yCoord = 10;
                fontR.func_175063_a(buffer, screenwidth / 2 - fontR.func_78256_a(buffer) / 2, yCoord, 0x2F96EB);

                String[] display = mod.getDisplayNames();
                int i = 0;
                while (i < display.length && display[i] != null)
                {
                    yCoord += 10;
                    fontR.func_175063_a(display[i], screenwidth / 2 - fontR.func_78256_a(display[i]) / 2, yCoord, 0xffffff);
                    i++;
                }

                GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);

                if (!retained)
                {
                    retainedTarget = target;
                    healthBarRetainTime = System.currentTimeMillis() + 3000L;
                }

            }
        }
    }

    private Entity getEntityCrosshairOver(float partialTicks, Minecraft mc)
    {

        Entity returnedEntity = null;
        Entity viewEntity = mc.func_175606_aa();

        if (mc.field_71441_e != null && viewEntity != null)
        {
            double distance = NAME_VISION_DISTANCE;
            RayTraceResult traceResult = viewEntity.func_174822_a(distance, partialTicks);
            Vec3d viewEntEyeVec = viewEntity.func_174824_e(partialTicks);

            if (traceResult != null)
            {
                distance = traceResult.field_72307_f.func_72438_d(viewEntEyeVec);
            }

            Vec3d lookVector = viewEntity.func_70676_i(1.0F);
            Vec3d viewEntEyeRay = viewEntEyeVec.func_72441_c(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance);
            Vec3d intersectVector = null;
            List<Entity> list = this.mc.field_71441_e.func_175674_a(viewEntity,
                    viewEntity.func_174813_aQ().func_72321_a(lookVector.field_72450_a * distance, lookVector.field_72448_b * distance, lookVector.field_72449_c * distance).func_72314_b(1.0D, 1.0D, 1.0D),
                    Predicates.and(EntitySelectors.field_180132_d, new Predicate<Entity>()
                    {
                        public boolean apply(@Nullable Entity e)
                        {
                            return e != null && e.func_70067_L();
                        }
                    }));

            for (Entity candidateHit : list)
            {
                AxisAlignedBB axisalignedbb = candidateHit.func_174813_aQ().func_186662_g((double) candidateHit.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(viewEntEyeVec, viewEntEyeRay);

                if (axisalignedbb.func_72318_a(viewEntEyeVec))
                {
                    if (distance >= 0.0D)
                    {
                        returnedEntity = candidateHit;
                        intersectVector = raytraceresult == null ? viewEntEyeVec : raytraceresult.field_72307_f;
                        distance = 0.0D;
                    }
                }
                else if (raytraceresult != null)
                {
                    double d3 = viewEntEyeVec.func_72438_d(raytraceresult.field_72307_f);
                    if (d3 < distance || distance == 0.0D)
                    {
                        if (candidateHit.func_184208_bv() == viewEntity.func_184208_bv() && !candidateHit.canRiderInteract())
                        {
                            if (distance == 0.0D)
                            {
                                returnedEntity = candidateHit;
                                intersectVector = raytraceresult.field_72307_f;
                            }
                        }
                        else
                        {
                            returnedEntity = candidateHit;
                            intersectVector = raytraceresult.field_72307_f;
                            distance = d3;
                        }
                    }
                }
            }

            if (returnedEntity != null && viewEntEyeVec.func_72438_d(intersectVector) > NAME_VISION_DISTANCE)
            {
                returnedEntity = null;
            }
        }
        return returnedEntity;
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent tick)
    {
        if (mc.field_71441_e == null || (mc.field_71462_r != null && mc.field_71462_r.func_73868_f()))
            return;

        /* client reset in case of swapping worlds */
        if (mc.field_71441_e != lastWorld)
        {
            boolean newGame = lastWorld == null;
            lastWorld = mc.field_71441_e;

            if (!newGame)
            {
                InfernalMobsCore.proxy.getRareMobs().clear();
            }
        }
    }

    @Override
    public ConcurrentHashMap<EntityLivingBase, MobModifier> getRareMobs()
    {
        return rareMobsClient;
    }

    @Override
    public void onHealthPacketForClient(int entID, float health, float maxhealth)
    {
        Entity ent = FMLClientHandler.instance().getClient().field_71441_e.func_73045_a(entID);
        if (ent != null && ent instanceof EntityLivingBase)
        {
            MobModifier mod = InfernalMobsCore.getMobModifiers((EntityLivingBase) ent);
            if (mod != null)
            {
                // System.out.printf("health packet [%f of %f] for %s\n",
                // health, maxhealth, ent);
                mod.setActualHealth(health, maxhealth);
            }
        }
    }

    @Override
    public void onKnockBackPacket(float xv, float zv)
    {
        MM_Gravity.knockBack(FMLClientHandler.instance().getClient().field_71439_g, xv, zv);
    }

    @Override
    public void onMobModsPacketToClient(String stringData, int entID)
    {
        InfernalMobsCore.instance().addRemoteEntityModifiers(FMLClientHandler.instance().getClient().field_71441_e, entID, stringData);
    }

    @Override
    public void onVelocityPacket(float xv, float yv, float zv)
    {
        FMLClientHandler.instance().getClient().field_71439_g.func_70024_g(xv, yv, zv);
    }

    @Override
    public void onAirPacket(int air)
    {
        airOverrideValue = air;
        airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    @SubscribeEvent
    public void onTick(RenderGameOverlayEvent.Pre event)
    {
        if (System.currentTimeMillis() > airDisplayTimeout) {
            airOverrideValue = -999;
        }
        
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR)
        {
            if (!mc.field_71439_g.func_70055_a(Material.field_151586_h) && airOverrideValue != -999)
            {
                final ScaledResolution res = new ScaledResolution(mc);
                GL11.glEnable(GL11.GL_BLEND);

                int right_height = 39;

                final int left = res.func_78326_a() / 2 + 91;
                final int top = res.func_78328_b() - right_height;
                final int full = MathHelper.func_76143_f((double) (airOverrideValue - 2) * 10.0D / 300.0D);
                final int partial = MathHelper.func_76143_f((double) airOverrideValue * 10.0D / 300.0D) - full;

                for (int i = 0; i < full + partial; ++i)
                {
                    mc.field_71456_v.func_73729_b(left - i * 8 - 9, top, (i < full ? 16 : 25), 18, 9, 9);
                }
                GL11.glDisable(GL11.GL_BLEND);
            }
        }
    }
}
