/*
 * Decompiled with CFR 0.152.
 */
package furgl.autoPickup.common.event;

import furgl.autoPickup.common.AutoPickup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DelayedPickupEvent {
    private static final int DELAY = 1;
    private static final int PICKUP_RADIUS = 2;
    private static ArrayList<Integer> delays = new ArrayList();
    private static ArrayList<EntityPlayer> players = new ArrayList();
    private static ArrayList<AxisAlignedBB> aabb = new ArrayList();

    public static boolean shouldAutoPickup(EntityPlayer player) {
        return player != null && !player.field_70170_p.field_72995_K && !(player instanceof FakePlayer) && !AutoPickup.keys.disable(player);
    }

    public static void setDelayedPickup(EntityPlayer player, double x, double y, double z) {
        if (DelayedPickupEvent.shouldAutoPickup(player)) {
            delays.add(1);
            players.add(player);
            aabb.add(new AxisAlignedBB(x - 2.0, y - 2.0, z - 2.0, x + 2.0, y + 2.0, z + 2.0));
        }
    }

    @SubscribeEvent
    public void onEvent(TickEvent.WorldTickEvent event) {
        if (players.size() > 0 && event.world == DelayedPickupEvent.players.get((int)0).field_70170_p && delays.set(0, delays.get(0) - 1) == 1) {
            List items = event.world.func_72872_a(EntityItem.class, aabb.get(0));
            for (EntityItem item : items) {
                AutoPickup.addItem(players.get(0), item.func_92059_d(), true);
            }
            List xpOrbs = event.world.func_72872_a(EntityXPOrb.class, aabb.get(0));
            for (EntityXPOrb xp : xpOrbs) {
                xp.func_70107_b(DelayedPickupEvent.players.get((int)0).field_70165_t, DelayedPickupEvent.players.get((int)0).field_70163_u, DelayedPickupEvent.players.get((int)0).field_70161_v);
            }
            players.remove(0);
            aabb.remove(0);
            delays.remove(0);
        }
    }

    @SubscribeEvent
    public void onEvent(LivingDropsEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            DelayedPickupEvent.setDelayedPickup((EntityPlayer)event.getSource().func_76346_g(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            DelayedPickupEvent.setDelayedPickup(event.getEntityPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
        }
    }

    @SubscribeEvent
    public void onEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            DelayedPickupEvent.setDelayedPickup(event.getEntityPlayer(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
        }
    }

    @SubscribeEvent
    public void onEvent(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K) {
            DelayedPickupEvent.setDelayedPickup(event.getPlayer(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
        }
    }

    @SubscribeEvent
    public void onEvent(AttackEntityEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            DelayedPickupEvent.setDelayedPickup(event.getEntityPlayer(), event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v);
        }
    }

    @SubscribeEvent
    public void onEvent(LivingExperienceDropEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getAttackingPlayer() != null && DelayedPickupEvent.shouldAutoPickup(event.getAttackingPlayer())) {
            EntityXPOrb xp = new EntityXPOrb(event.getEntity().field_70170_p, event.getAttackingPlayer().field_70165_t, event.getAttackingPlayer().field_70163_u, event.getAttackingPlayer().field_70161_v, event.getDroppedExperience());
            event.getEntity().field_70170_p.func_72838_d((Entity)xp);
            event.setDroppedExperience(0);
        }
    }
}

