/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.entities.projectiles.DTEntityBoomGrenade;
import pegbeard.dungeontactics.entities.projectiles.DTEntityCryoGrenade;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPortGrenade;
import pegbeard.dungeontactics.entities.projectiles.DTEntityPyroGrenade;
import pegbeard.dungeontactics.entities.projectiles.DTThrowableGeneric;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.items.DTItemGeneric;

public class DTGrenade
extends DTItemGeneric {
    public DTGrenade(String name) {
        super(name);
        this.func_77637_a(DTCreativeTab.DT_COMBAT_TAB);
        this.func_77625_d(16);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public int func_77619_b() {
        return 0;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
            boolean cluster = false;
            DTThrowableGeneric grenade = new DTEntityBoomGrenade(world);
            if (!player.field_71075_bZ.field_75098_d) {
                entityLiving.func_70669_a(stack);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
            if (this == DTItems.GRENADE_BOOM_CLUSTER || this == DTItems.GRENADE_PYRO_CLUSTER || this == DTItems.GRENADE_CRYO_CLUSTER || this == DTItems.GRENADE_PORTING_CLUSTER) {
                cluster = true;
            }
            if (this == DTItems.GRENADE_PYRO || this == DTItems.GRENADE_PYRO_CLUSTER) {
                grenade = new DTEntityPyroGrenade(world);
            }
            if (this == DTItems.GRENADE_CRYO || this == DTItems.GRENADE_CRYO_CLUSTER) {
                grenade = new DTEntityCryoGrenade(world);
            }
            if (this == DTItems.GRENADE_PORTING || this == DTItems.GRENADE_PORTING_CLUSTER) {
                grenade = new DTEntityPortGrenade(world);
            }
            if (!world.field_72995_K) {
                grenade.func_70634_a(player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5);
                if (cluster) {
                    for (int i = 0; i < 5; ++i) {
                        grenade.fuse = world.field_73012_v.nextInt(10) + world.field_73012_v.nextInt(10);
                        grenade.func_70186_c(field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat(), 0.3f, 0.1f);
                        world.func_72838_d((Entity)grenade);
                    }
                } else {
                    grenade.func_70186_c(field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat(), field_77697_d.nextFloat() - field_77697_d.nextFloat(), 0.3f, 0.1f);
                    world.func_72838_d((Entity)grenade);
                }
            }
        }
        return stack;
    }

    private ItemStack hasIgniter(EntityPlayer player) {
        if (this.isIgniter(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isIgniter(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isIgniter(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isIgniter(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof ItemFlintAndSteel || stack.func_77973_b() instanceof ItemFireball || stack.func_77973_b() == Items.field_151065_br || stack.func_77973_b() == Items.field_151072_bj || stack.func_77973_b() == Items.field_151129_at);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack igniterType = this.hasIgniter(player);
        boolean flag = player.field_71075_bZ.field_75098_d;
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)player.func_184586_b(hand), (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (igniterType.func_190926_b() && !flag) {
            return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand)) : new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (!flag && !igniterType.func_190926_b() && igniterType.func_77973_b() == Items.field_151033_d) {
            igniterType.func_77972_a(1, (EntityLivingBase)player);
        }
        player.func_184598_c(hand);
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187572_ar, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static float getProjectileVelocity(int charge) {
        float f = (float)charge / 10.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack igniterType = this.hasIgniter(player);
            boolean flag = player.field_71075_bZ.field_75098_d;
            int i = this.func_77626_a(stack) - timeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entityLiving), (int)i, (stack != null ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!igniterType.func_190926_b() || flag) {
                boolean cluster = false;
                DTThrowableGeneric grenade = new DTEntityBoomGrenade(world, (EntityLivingBase)player);
                float f = DTGrenade.getProjectileVelocity(i);
                if (f >= 0.5f) {
                    if (!flag) {
                        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                    world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187866_fi, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    if (!world.field_72995_K) {
                        float v = f * 1.5f;
                        if (this == DTItems.GRENADE_BOOM_CLUSTER || this == DTItems.GRENADE_PYRO_CLUSTER || this == DTItems.GRENADE_CRYO_CLUSTER || this == DTItems.GRENADE_PORTING_CLUSTER) {
                            cluster = true;
                        }
                        if (this == DTItems.GRENADE_PYRO || this == DTItems.GRENADE_PYRO_CLUSTER) {
                            grenade = new DTEntityPyroGrenade(world, (EntityLivingBase)player);
                        }
                        if (this == DTItems.GRENADE_CRYO || this == DTItems.GRENADE_CRYO_CLUSTER) {
                            grenade = new DTEntityCryoGrenade(world, (EntityLivingBase)player);
                        }
                        if (this == DTItems.GRENADE_PORTING || this == DTItems.GRENADE_PORTING_CLUSTER) {
                            grenade = new DTEntityPortGrenade(world, (EntityLivingBase)player);
                        }
                        grenade.fuse = timeLeft;
                        grenade.cluster = cluster;
                        grenade.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.1f, v, 1.0f);
                        world.func_72838_d((Entity)grenade);
                    }
                }
            }
        }
    }
}

