/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.DTItems;
import pegbeard.dungeontactics.handlers.client.DTKeyRegister;
import pegbeard.dungeontactics.proxy.network.DTMessageRocketBoost;
import pegbeard.dungeontactics.proxy.network.DTMessageRocketJump;
import pegbeard.dungeontactics.proxy.network.NetworkHandler;
import pegbeard.dungeontactics.reference.DTMaterials;

public class DTArmourAdventure
extends ItemArmor {
    public DTArmourAdventure(String name, ItemArmor.ArmorMaterial material, int renderType, EntityEquipmentSlot slot) {
        super(material, renderType, slot);
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        if (material == DTMaterials.Armour.STUDDED) {
            this.func_77637_a(DTCreativeTab.DT_COMBAT_TAB);
        } else {
            this.func_77637_a(DTCreativeTab.DT_TAB);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (this.func_82812_d() == DTMaterials.Armour.ENGINEER) {
            return "dungeontactics".toLowerCase() + ":textures/models/armor/" + this.func_82812_d().toString().toLowerCase() + "_clothes.png";
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return "dungeontactics".toLowerCase() + ":textures/models/armor/" + this.func_82812_d().toString().toLowerCase() + "_layer_2.png";
        }
        return "dungeontactics".toLowerCase() + ":textures/models/armor/" + this.func_82812_d().toString().toLowerCase() + "_layer_1.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (world.field_72995_K) {
            ItemStack pants;
            KeyBinding[] keyBindings = DTKeyRegister.keyBindings;
            if (!player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == DTItems.REXO_LEGGINGS && (player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != DTItems.REXO_GOGGLES) && keyBindings[0].func_151468_f() && player != null && !(pants = player.func_184582_a(EntityEquipmentSlot.LEGS)).func_190926_b() && pants.func_77973_b() == DTItems.REXO_LEGGINGS) {
                DTArmourAdventure.burst(world, player, pants);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new DTMessageRocketJump(pants));
            }
            if (!player.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == DTItems.REXO_LEGGINGS && !player.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == DTItems.REXO_GOGGLES) {
                if (!(player.field_70122_E || player.func_70617_f_() || player.func_70090_H() || player.field_71075_bZ.field_75100_b || !keyBindings[0].func_151470_d() || !player.field_71071_by.func_70431_c(new ItemStack(Items.field_151016_H)) && !player.func_184812_l_() || player == null)) {
                    player.field_71075_bZ.field_75101_c = true;
                    pants = player.func_184582_a(EntityEquipmentSlot.LEGS);
                    if (!pants.func_190926_b() && pants.func_77973_b() == DTItems.REXO_LEGGINGS) {
                        DTArmourAdventure.boost(world, player, pants);
                        NetworkHandler.INSTANCE.sendToServer((IMessage)new DTMessageRocketBoost(pants));
                    }
                }
                if (!keyBindings[0].func_151470_d() && player.field_71075_bZ.field_75101_c && !player.field_71075_bZ.field_75098_d) {
                    player.field_71075_bZ.field_75101_c = false;
                }
            }
        }
    }

    public static void burst(World world, EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() <= stack.func_77958_k()) {
            ItemStack fuel = new ItemStack(Items.field_151016_H);
            if ((player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(fuel)) && player.field_70122_E && !player.func_70093_af() && !player.func_70090_H()) {
                int i;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                    for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151016_H) continue;
                        itemstack.func_190918_g(1);
                        if (!itemstack.func_190926_b()) break;
                        player.field_71071_by.func_184437_d(itemstack);
                        break;
                    }
                }
                if (world.field_72995_K) {
                    for (i = 0; i < 30; ++i) {
                        world.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t, player.field_70163_u + 0.3, player.field_70161_v, field_77697_d.nextGaussian() * 0.05, -player.field_70181_x * 0.5, field_77697_d.nextGaussian() * 0.05, new int[0]);
                    }
                }
                if (!world.field_72995_K) {
                    player.field_70181_x = 2.0;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187631_bo, SoundCategory.PLAYERS, 0.7f, (float)field_77697_d.nextGaussian());
                }
            }
        }
    }

    public static void boost(World world, EntityPlayer player, ItemStack stack) {
        if (stack.func_77952_i() <= stack.func_77958_k()) {
            if (world.field_72995_K) {
                world.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, player.field_70165_t, player.field_70163_u + 0.3, player.field_70161_v, field_77697_d.nextGaussian() * 0.05, -player.field_70181_x * 0.5, field_77697_d.nextGaussian() * 0.05, new int[0]);
            }
            if (!world.field_72995_K) {
                if (player.func_184613_cA()) {
                    float yaw = player.field_70177_z;
                    float pitch = player.field_70125_A;
                    float f = 0.05f;
                    double motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f;
                    double motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI)) * f;
                    double motionY = -MathHelper.func_76126_a((float)(pitch / 180.0f * (float)Math.PI)) * f;
                    if (player.field_70159_w < 0.5 && player.field_70159_w > -0.5) {
                        player.field_70159_w += motionX;
                    }
                    if (player.field_70179_y < 0.5 && player.field_70179_y > -0.5) {
                        player.field_70179_y += motionZ;
                    }
                    if (player.field_70181_x < 0.5 && player.field_70181_x > -0.5) {
                        player.field_70181_x += motionY;
                    }
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                } else if (player.field_70181_x < 0.4) {
                    player.field_70181_x += 0.151;
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)player)));
                    if (player.field_70143_R > 1.0f) {
                        player.field_70143_R -= 1.0f;
                        if (player.field_70143_R < 1.0f || player.field_70143_R > 1.0f && player.field_70143_R < 2.0f) {
                            player.field_70143_R = 1.0f;
                        }
                    }
                }
                if (!player.field_71075_bZ.field_75098_d && world.func_82737_E() % 40L == 0L) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151016_H) continue;
                        itemstack.func_190918_g(1);
                        if (!itemstack.func_190926_b()) break;
                        player.field_71071_by.func_184437_d(itemstack);
                        break;
                    }
                }
            }
        }
    }

    public static void bounce(World world, EntityLivingBase entity, ItemStack stack, float distance) {
        if (stack.func_77952_i() <= stack.func_77958_k()) {
            if (!entity.func_70093_af() && distance > 10.0f) {
                stack.func_77972_a(1, entity);
            }
            if (world.field_72995_K) {
                int i = 0;
                while ((float)i < distance) {
                    world.func_175688_a(EnumParticleTypes.SLIME, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, field_77697_d.nextGaussian(), 0.0, field_77697_d.nextGaussian(), new int[0]);
                    world.func_175688_a(EnumParticleTypes.SLIME, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, field_77697_d.nextGaussian(), 0.0, field_77697_d.nextGaussian(), new int[0]);
                    ++i;
                }
            }
            if (!world.field_72995_K) {
                if (!entity.func_70093_af()) {
                    double d = 0.4 + (double)Math.abs(distance) * 0.2;
                    entity.field_70181_x = d / 4.0;
                    entity.field_70160_al = true;
                    entity.field_70122_E = false;
                    if (entity instanceof EntityPlayer) {
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)((EntityPlayerMP)entity)));
                    }
                }
                world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187882_fq, SoundCategory.PLAYERS, 0.5f, (float)field_77697_d.nextGaussian());
            }
        }
    }
}

