/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.reference.Reference;
import pegbeard.dungeontactics.worldgen.DTDungeon;
import pegbeard.dungeontactics.worldgen.DTTemplates;
import pegbeard.dungeontactics.worldgen.DTTower;
import pegbeard.dungeontactics.worldgen.DTWorldDecorator;

public class DTWorldGen
implements IWorldGenerator {
    int flowers = DTConfigHandler.configuration.get("7-World", "2-Flower Generation", 32).getInt(32);
    int netherGold = DTConfigHandler.configuration.get("7-World", "1.1-Nether Gold", 6).getInt(6);
    int stoneQuartz = DTConfigHandler.configuration.get("7-World", "1.2-Overworld Quartz", 6).getInt(6);
    int endDiamond = DTConfigHandler.configuration.get("7-World", "1.3-Overworld Quartz", 6).getInt(6);
    int endLapis = DTConfigHandler.configuration.get("7-World", "1.4-Overworld Quartz", 6).getInt(6);
    boolean structures = DTConfigHandler.configuration.get("7-World", "3-Dungeon Generation", true).getBoolean(true);
    int dungeonDistance = DTConfigHandler.configuration.get("7-World", "4.1-Dungeon Spacing", 1000).getInt(1000);
    int shipDistance = DTConfigHandler.configuration.get("7-World", "4.2-Ship Spacing", 500).getInt(500);

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateOverworld(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
        if (DTConfigHandler.canSpawnHere(world)) {
            this.generateDungeon(world, rand, chunkX * 16, chunkZ * 16);
        }
    }

    private static int floordiv(int start, int distance) {
        if (start % distance != 0) {
            // empty if block
        }
        return start / distance - (start < 0 ^ distance < 0 ? 1 : 0);
    }

    private boolean chunkContainsASpawnPosition(int coord, int spacing) {
        int chunksize = 16;
        int lowerEdge = DTWorldGen.floordiv(coord - 1, spacing);
        int upperEdge = DTWorldGen.floordiv(coord + chunksize - 1, spacing);
        return upperEdge - lowerEdge == 1;
    }

    private void generateNether(World world, Random rand, int chunkXStart, int chunkZStart) {
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        if (this.netherGold > 0) {
            for (int k = 0; k < this.netherGold; ++k) {
                int XCoord = chunkXStart + rand.nextInt(16);
                int YCoord = 5 + rand.nextInt(118);
                int ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.NETHER_GOLD.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        for (int i = 0; i < this.flowers / 2; ++i) {
            BlockPos pos = new BlockPos(chunkX + rand.nextInt(16), 5 + rand.nextInt(118), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.GLOWCURRENT_BUSH);
        }
    }

    private void generateOverworld(World world, Random rand, int chunkXStart, int chunkZStart) {
        int i;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
        Biome biome = world.field_73011_w.getBiomeForCoords(pos);
        Property configBiomes = DTConfigHandler.configuration.get("8-WorldGen", "1-Flower Biomes", Reference.FLOWERBIOMESDEFAULT);
        ArrayList<String> biomeList = new ArrayList<String>(Arrays.asList(configBiomes.getStringList()));
        if (this.stoneQuartz > 0) {
            for (int k = 0; k < this.stoneQuartz; ++k) {
                int XCoord = chunkXStart + rand.nextInt(16);
                int YCoord = 3 + rand.nextInt(12);
                int ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.STONE_QUARTZ.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.flowers > 0) {
            if (biomeList.contains(biome.getRegistryName().toString())) {
                for (i = 0; i < this.flowers; ++i) {
                    pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
                    if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                    new DTWorldDecorator().generateFlower(world, rand, pos);
                }
            }
            for (i = 0; i < this.flowers; ++i) {
                pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
                if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
                new DTWorldDecorator().generateFlower(world, rand, pos);
            }
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), 52 + rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.CHERRYBOMB_BUSH);
        }
        for (i = 0; i < this.flowers / 2; ++i) {
            pos = new BlockPos(chunkX + rand.nextInt(16), rand.nextInt(48), chunkZ + rand.nextInt(16));
            if (!world.func_175623_d(pos) || !world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150362_t || world.func_180495_p(pos.func_177977_b()) == Blocks.field_150361_u) continue;
            new DTWorldDecorator().generateBush(world, rand, pos, DTBlocks.INCINDIBERRY_BUSH);
        }
    }

    private void generateEnd(World world, Random rand, int chunkXStart, int chunkZStart) {
        int ZCoord;
        int YCoord;
        int XCoord;
        int k;
        int chunkX = chunkXStart + 8;
        int chunkZ = chunkZStart + 8;
        if (this.endDiamond > 0) {
            for (k = 0; k < this.endDiamond; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 5 + rand.nextInt(118);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.END_DIAMOND.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
        if (this.endLapis > 0) {
            for (k = 0; k < this.endLapis; ++k) {
                XCoord = chunkXStart + rand.nextInt(16);
                YCoord = 5 + rand.nextInt(118);
                ZCoord = chunkZStart + rand.nextInt(16);
                new WorldGenMinable(DTBlocks.END_LAPIS.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs)).func_180709_b(world, rand, new BlockPos(XCoord, YCoord, ZCoord));
            }
        }
    }

    private void generateDungeon(World world, Random rand, int chunkXStart, int chunkZStart) {
        if (this.structures && world.func_72912_H().func_76089_r()) {
            int multiplier = 16 * (rand.nextInt(6) - rand.nextInt(6));
            int chunkX = chunkXStart + 8;
            int chunkZ = chunkZStart + 8;
            BlockPos pos = new BlockPos(chunkX, world.func_72940_L(), chunkZ);
            Biome biome = world.field_73011_w.getBiomeForCoords(pos);
            int finalY = world.func_72940_L();
            if (world.field_73011_w.getDimension() == -1) {
                finalY = world.func_181545_F() / 2 + (rand.nextInt(25) - rand.nextInt(25));
            }
            int finalX = chunkX + multiplier;
            int finalZ = chunkZ + multiplier;
            int voidY = 63 + rand.nextInt(10) - rand.nextInt(10);
            if (this.chunkContainsASpawnPosition(chunkX, this.dungeonDistance) && this.chunkContainsASpawnPosition(chunkZ, this.dungeonDistance)) {
                while (world.func_175623_d(new BlockPos(finalX, finalY, finalZ)) && finalY > 1) {
                    --finalY;
                }
                if (world.func_175623_d(new BlockPos(finalX, 0, finalZ))) {
                    finalY = voidY;
                }
                if (finalY < 1) {
                    finalY = 1;
                }
                if (!(world.func_180495_p(pos = new BlockPos(finalX, finalY + 2, finalZ)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(3)).func_177230_c() instanceof BlockLiquid)) {
                    int chance = rand.nextInt(5);
                    if (chance == 0 && pos.func_177956_o() >= 20) {
                        new DTDungeon().settle(world, rand, pos);
                    } else if (chance == 1 && pos.func_177956_o() >= 20) {
                        new DTTower().settle(world, rand, pos);
                    } else if (chance == 2 && pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateTower(world, rand, pos);
                    } else if (chance == 3 && pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateMiniBunker(world, rand, pos);
                    } else if (pos.func_177956_o() >= 20 && world.field_73011_w.getDimension() != -1) {
                        new DTTemplates().generateWaggon(world, rand, pos);
                    }
                }
            }
            if (this.chunkContainsASpawnPosition(chunkX, this.shipDistance) && this.chunkContainsASpawnPosition(chunkZ, this.shipDistance) && (world.func_180495_p(pos = new BlockPos(finalX, finalY = world.func_181545_F(), finalZ)).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLiquid || world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof BlockLiquid)) {
                new DTTemplates().func_180709_b(world, rand, pos);
            }
        }
    }
}

