/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class QuestDatabase
extends SimpleDatabase<IQuest>
implements IQuestDatabase {
    public static final QuestDatabase INSTANCE = new QuestDatabase();

    @Override
    public IQuest createNew(int id) {
        return this.add(id, new QuestInstance()).getValue();
    }

    @Override
    public synchronized List<DBEntry<IQuest>> bulkLookup(int ... ids) {
        if (ids == null || ids.length <= 0) {
            return Collections.emptyList();
        }
        ArrayList<DBEntry<IQuest>> values = new ArrayList<DBEntry<IQuest>>();
        for (int i : ids) {
            IQuest v = (IQuest)this.getValue(i);
            if (v == null) continue;
            values.add(new DBEntry<IQuest>(i, v));
        }
        return values;
    }

    @Override
    public synchronized boolean removeID(int id) {
        boolean success = super.removeID(id);
        if (success) {
            for (DBEntry entry : this.getEntries()) {
                this.removeReq((IQuest)entry.getValue(), id);
            }
        }
        return success;
    }

    @Override
    public synchronized boolean removeValue(IQuest value) {
        int id = this.getID(value);
        if (id < 0) {
            return false;
        }
        boolean success = this.removeValue(value);
        if (success) {
            for (DBEntry entry : this.getEntries()) {
                this.removeReq((IQuest)entry.getValue(), id);
            }
        }
        return success;
    }

    private void removeReq(IQuest quest, int id) {
        int[] orig = quest.getRequirements();
        if (orig.length <= 0) {
            return;
        }
        boolean hasRemoved = false;
        int[] rem = new int[orig.length - 1];
        for (int i = 0; i < orig.length; ++i) {
            if (!hasRemoved && orig[i] == id) {
                hasRemoved = true;
                continue;
            }
            if (!hasRemoved && i >= rem.length) break;
            rem[!hasRemoved ? i : i - 1] = orig[i];
        }
        if (hasRemoved) {
            quest.setRequirements(rem);
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        NBTTagCompound base = new NBTTagCompound();
        base.func_74782_a("config", (NBTBase)this.writeToNBT(new NBTTagList(), (List<UUID>)null));
        base.func_74782_a("progress", (NBTBase)this.writeProgressToNBT(new NBTTagList(), (List<UUID>)null));
        tags.func_74782_a("data", (NBTBase)base);
        return new QuestingPacket(PacketTypeNative.QUEST_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        NBTTagCompound base = payload.func_74775_l("data");
        this.readFromNBT(base.func_150295_c("config", 10), false);
        this.readProgressFromNBT(base.func_150295_c("progress", 10), false);
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList json, List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeToNBT(jq);
            jq.func_74768_a("questID", entry.getID());
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList nbt, boolean merge) {
        this.reset();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            int qID;
            NBTTagCompound qTag = nbt.func_150305_b(i);
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0) continue;
            IQuest quest = (IQuest)this.getValue(qID);
            quest = quest != null ? quest : this.createNew(qID);
            quest.readFromNBT(qTag);
        }
    }

    @Override
    public synchronized NBTTagList writeProgressToNBT(NBTTagList json, List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jq = new NBTTagCompound();
            ((IQuest)entry.getValue()).writeProgressToNBT(jq, users);
            jq.func_74768_a("questID", entry.getID());
            json.func_74742_a((NBTBase)jq);
        }
        return json;
    }

    @Override
    public synchronized void readProgressFromNBT(NBTTagList json, boolean merge) {
        for (int i = 0; i < json.func_74745_c(); ++i) {
            IQuest quest;
            int qID;
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound qTag = (NBTTagCompound)entry;
            int n = qID = qTag.func_150297_b("questID", 99) ? qTag.func_74762_e("questID") : -1;
            if (qID < 0 || (quest = (IQuest)this.getValue(qID)) == null) continue;
            quest.readProgressFromNBT(qTag, merge);
        }
    }
}

