/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.IPacketHandler;
import betterquesting.api.questing.IQuestLine;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLine;
import betterquesting.questing.QuestLineDatabase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;

public class PktHandlerLineEdit
implements IPacketHandler {
    @Override
    public ResourceLocation getRegistryName() {
        return PacketTypeNative.LINE_EDIT.GetLocation();
    }

    @Override
    public void handleServer(NBTTagCompound data, EntityPlayerMP sender) {
        if (sender == null || sender.func_184102_h() == null) {
            return;
        }
        boolean isOP = sender.func_184102_h().func_184103_al().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit quest lines without OP permissions!");
            sender.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to be OP to edit quests!"), false);
            return;
        }
        int aID = !data.func_74764_b("action") ? -1 : data.func_74762_e("action");
        int lID = !data.func_74764_b("lineID") ? -1 : data.func_74762_e("lineID");
        int idx = !data.func_74764_b("order") ? -1 : data.func_74762_e("order");
        IQuestLine questLine = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(lID);
        if (aID < 0 || aID >= EnumPacketAction.values().length) {
            return;
        }
        EnumPacketAction action = EnumPacketAction.values()[aID];
        if (action == EnumPacketAction.ADD) {
            QuestLine nq = new QuestLine();
            int nID = QuestLineDatabase.INSTANCE.nextID();
            if (data.func_74764_b("data") && lID >= 0) {
                nID = lID;
                NBTTagCompound base = data.func_74775_l("data");
                nq.readFromNBT(base.func_74775_l("line"), false);
            }
            QuestLineDatabase.INSTANCE.add(nID, nq);
            PacketSender.INSTANCE.sendToAll(nq.getSyncPacket());
        } else if (action == EnumPacketAction.EDIT && questLine != null) {
            questLine.readPacket(data);
            if (idx >= 0 && QuestLineDatabase.INSTANCE.getOrderIndex(lID) != idx) {
                QuestLineDatabase.INSTANCE.setOrderIndex(lID, idx);
                PacketSender.INSTANCE.sendToAll(QuestLineDatabase.INSTANCE.getSyncPacket());
            } else {
                PacketSender.INSTANCE.sendToAll(questLine.getSyncPacket());
            }
        } else if (action == EnumPacketAction.REMOVE && questLine != null) {
            QuestLineDatabase.INSTANCE.removeID(lID);
            PacketSender.INSTANCE.sendToAll(QuestLineDatabase.INSTANCE.getSyncPacket());
        }
    }

    @Override
    public void handleClient(NBTTagCompound data) {
    }
}

