/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.TreeSet;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;

public class QuestCommandPurge
extends QuestCommandBase {
    @Override
    public String getCommand() {
        return "purge_hidden_quests";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) {
        TreeSet<Integer> knownKeys = new TreeSet<Integer>();
        for (DBEntry dBEntry : QuestLineDatabase.INSTANCE.getEntries()) {
            DBEntry<T>[] dBEntryArray = ((IQuestLine)dBEntry.getValue()).getEntries();
            int n = dBEntryArray.length;
            for (int i = 0; i < n; ++i) {
                DBEntry qle = dBEntryArray[i];
                knownKeys.add(qle.getID());
            }
        }
        Iterator keyIterator = knownKeys.iterator();
        ArrayDeque<Integer> removeQueue = new ArrayDeque<Integer>();
        int n = -1;
        for (DBEntry entry : QuestDatabase.INSTANCE.getEntries()) {
            while (n < entry.getID() && keyIterator.hasNext()) {
                n = (Integer)keyIterator.next();
            }
            if (n == entry.getID()) continue;
            removeQueue.add(entry.getID());
        }
        int n2 = removeQueue.size();
        while (removeQueue.size() > 0) {
            QuestDatabase.INSTANCE.removeID((Integer)removeQueue.pop());
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.purge_hidden", new Object[]{n2}));
        PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
        SaveLoadHandler.INSTANCE.markDirty();
    }

    @Override
    public String getPermissionNode() {
        return "betterquesting.command.admin.purge";
    }

    @Override
    public DefaultPermissionLevel getPermissionLevel() {
        return DefaultPermissionLevel.OP;
    }

    @Override
    public String getPermissionDescription() {
        return "Permission to purge all hidden quests and progression data however it does not delete any in new world defaults";
    }
}

