/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabase;
import java.util.BitSet;
import java.util.Map;
import java.util.TreeMap;

public abstract class SimpleDatabase<T>
implements IDatabase<T> {
    private final TreeMap<Integer, T> mapDB = new TreeMap();
    private final BitSet idMap = new BitSet();
    private DBEntry<T>[] refCache = null;

    @Override
    public synchronized int nextID() {
        return this.idMap.nextClearBit(0);
    }

    @Override
    public synchronized DBEntry<T> add(int id, T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (id < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        if (this.mapDB.putIfAbsent(id, value) == null) {
            this.idMap.set(id);
            this.refCache = null;
            return new DBEntry<T>(id, value);
        }
        throw new IllegalArgumentException("ID or value is already contained within database");
    }

    @Override
    public synchronized boolean removeID(int key) {
        if (key < 0) {
            return false;
        }
        if (this.mapDB.remove(key) != null) {
            this.idMap.clear(key);
            this.refCache = null;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeValue(T value) {
        return value != null && this.removeID(this.getID(value));
    }

    @Override
    public synchronized int getID(T value) {
        if (value == null) {
            return -1;
        }
        for (DBEntry<T> entry : this.getEntries()) {
            if (entry.getValue() != value) continue;
            return entry.getID();
        }
        return -1;
    }

    @Override
    public synchronized T getValue(int id) {
        if (id < 0 || this.mapDB.size() <= 0) {
            return null;
        }
        return this.mapDB.get(id);
    }

    @Override
    public synchronized int size() {
        return this.mapDB.size();
    }

    @Override
    public synchronized void reset() {
        this.mapDB.clear();
        this.idMap.clear();
        this.refCache = new DBEntry[0];
    }

    @Override
    public synchronized DBEntry<T>[] getEntries() {
        if (this.refCache == null) {
            this.refCache = new DBEntry[this.mapDB.size()];
            int i = 0;
            for (Map.Entry<Integer, T> entry : this.mapDB.entrySet()) {
                this.refCache[i++] = new DBEntry<T>(entry.getKey(), entry.getValue());
            }
        }
        return this.refCache;
    }
}

