/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class SlideShowTexture
implements IGuiTexture {
    private final IGuiTexture[] slides;
    private final float interval;

    public SlideShowTexture(float interval, IGuiTexture ... slides) {
        this.slides = slides;
        this.interval = interval;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick) {
        IGuiTexture tex = this.getCurrentFrame();
        if (tex != null) {
            tex.drawTexture(x, y, width, height, zLevel, partialTick);
        }
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
        if (width <= 0 || height <= 0) {
            return;
        }
        IGuiTexture tex = this.getCurrentFrame();
        if (tex != null) {
            tex.drawTexture(x, y, width, height, zDepth, partialTick, color);
        }
    }

    @Override
    @Deprecated
    public ResourceLocation getTexture() {
        IGuiTexture tex = this.getCurrentFrame();
        return tex == null ? null : tex.getTexture();
    }

    @Override
    @Deprecated
    public IGuiRect getBounds() {
        IGuiTexture tex = this.getCurrentFrame();
        return tex == null ? null : tex.getBounds();
    }

    @Nullable
    public IGuiTexture getCurrentFrame() {
        if (this.slides.length <= 0) {
            return null;
        }
        return this.slides[(int)Math.floor((double)System.currentTimeMillis() / 1000.0 % (double)((float)this.slides.length * this.interval) / (double)this.interval)];
    }

    public IGuiTexture[] getAllFrames() {
        return this.slides;
    }
}

