/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.cache;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.storage.DBEntry;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import java.util.Collection;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;

public class QuestCache
implements INBTSerializable<NBTTagCompound> {
    private final Boolean syncLock = false;
    private final TreeSet<Integer> visibleQuests = new TreeSet();
    private final TreeSet<Integer> activeQuests = new TreeSet();
    private final TreeSet<QResetTime> resetSchedule = new TreeSet((o1, o2) -> o1.questID == o2.questID ? 0 : Long.compare(o2.time, o1.time));
    private final TreeSet<Integer> autoClaims = new TreeSet();
    private final TreeSet<Integer> markedDirty = new TreeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getActiveQuests() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            int i = 0;
            int[] aryAct = new int[this.activeQuests.size()];
            for (Integer q : this.activeQuests) {
                aryAct[i++] = q;
            }
            return aryAct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVisibleQuests() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            int i = 0;
            int[] aryVis = new int[this.visibleQuests.size()];
            for (Integer q : this.visibleQuests) {
                aryVis[i++] = q;
            }
            return aryVis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getPendingAutoClaims() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            int i = 0;
            int[] aryAC = new int[this.autoClaims.size()];
            for (Integer q : this.autoClaims) {
                aryAC[i++] = q;
            }
            return aryAC;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QResetTime[] getScheduledResets() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            return this.resetSchedule.toArray(new QResetTime[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markQuestDirty(int questID) {
        if (questID < 0) {
            return;
        }
        Boolean bl = this.syncLock;
        synchronized (bl) {
            this.markedDirty.add(questID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markQuestClean(int questID) {
        if (questID < 0) {
            return;
        }
        Boolean bl = this.syncLock;
        synchronized (bl) {
            this.markedDirty.remove(questID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAllQuests() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            this.markedDirty.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getDirtyQuests() {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            int i = 0;
            int[] aryMD = new int[this.markedDirty.size()];
            for (Integer q : this.markedDirty) {
                aryMD[i++] = q;
            }
            return aryMD;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache(EntityPlayer player) {
        if (player == null) {
            return;
        }
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        DBEntry<T>[] questDB = QuestingAPI.getAPI(ApiReference.QUEST_DB).getEntries();
        NonNullList tmpVisible = NonNullList.func_191196_a();
        NonNullList tmpActive = NonNullList.func_191196_a();
        NonNullList tmpReset = NonNullList.func_191196_a();
        NonNullList tmpAutoClaim = NonNullList.func_191196_a();
        for (DBEntry entry : questDB) {
            if (((IQuest)entry.getValue()).isUnlocked(uuid) || ((IQuest)entry.getValue()).getProperty(NativeProps.LOCKED_PROGRESS).booleanValue()) {
                int repeat = ((IQuest)entry.getValue()).getProperty(NativeProps.REPEAT_TIME);
                NBTTagCompound ue = ((IQuest)entry.getValue()).getCompletionInfo(uuid);
                if (ue == null && ((IQuest)entry.getValue()).getTasks().size() <= 0 || ((IQuest)entry.getValue()).canSubmit(player)) {
                    tmpActive.add((Object)entry.getID());
                } else if (ue != null) {
                    if (repeat >= 0 && ((IQuest)entry.getValue()).hasClaimed(uuid)) {
                        tmpReset.add((Object)new QResetTime(entry.getID(), ue.func_74763_f("timestamp") + (long)repeat));
                    }
                    if (!((IQuest)entry.getValue()).hasClaimed(uuid) && ((IQuest)entry.getValue()).getProperty(NativeProps.AUTO_CLAIM).booleanValue()) {
                        tmpAutoClaim.add((Object)entry.getID());
                    }
                }
            }
            if (!QuestCache.isQuestShown((IQuest)entry.getValue(), uuid, player)) continue;
            tmpVisible.add((Object)entry.getID());
        }
        Boolean bl = this.syncLock;
        synchronized (bl) {
            this.visibleQuests.clear();
            this.visibleQuests.addAll((Collection<Integer>)tmpVisible);
            this.activeQuests.clear();
            this.activeQuests.addAll((Collection<Integer>)tmpActive);
            this.resetSchedule.clear();
            this.resetSchedule.addAll((Collection<QResetTime>)tmpReset);
            this.autoClaims.clear();
            this.autoClaims.addAll((Collection<Integer>)tmpAutoClaim);
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("data", (NBTBase)this.serializeNBT());
        if (player instanceof EntityPlayerMP) {
            QuestingAPI.getAPI(ApiReference.PACKET_SENDER).sendToPlayer(new QuestingPacket(PacketTypeNative.CACHE_SYNC.GetLocation(), nBTTagCompound), (EntityPlayerMP)player);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74783_a("visibleQuests", this.getVisibleQuests());
        tags.func_74783_a("activeQuests", this.getActiveQuests());
        tags.func_74783_a("autoClaims", this.getPendingAutoClaims());
        tags.func_74783_a("markedDirty", this.getDirtyQuests());
        NBTTagList tagSchedule = new NBTTagList();
        for (QResetTime entry : this.getScheduledResets()) {
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("quest", entry.questID);
            tagEntry.func_74772_a("time", entry.time);
            tagSchedule.func_74742_a((NBTBase)tagEntry);
        }
        tags.func_74782_a("resetSchedule", (NBTBase)tagSchedule);
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeNBT(NBTTagCompound nbt) {
        Boolean bl = this.syncLock;
        synchronized (bl) {
            this.visibleQuests.clear();
            this.activeQuests.clear();
            this.resetSchedule.clear();
            this.autoClaims.clear();
            this.markedDirty.clear();
            for (int i : nbt.func_74759_k("visibleQuests")) {
                this.visibleQuests.add(i);
            }
            for (int i : nbt.func_74759_k("activeQuests")) {
                this.activeQuests.add(i);
            }
            for (int i : nbt.func_74759_k("autoClaims")) {
                this.autoClaims.add(i);
            }
            for (int i : nbt.func_74759_k("markedDirty")) {
                this.markedDirty.add(i);
            }
            NBTTagList tagList = nbt.func_150295_c("resetSchedule", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagEntry = tagList.func_150305_b(i);
                if (!tagEntry.func_150297_b("quest", 99)) continue;
                this.resetSchedule.add(new QResetTime(tagEntry.func_74762_e("quest"), tagEntry.func_74763_f("time")));
            }
        }
    }

    public static boolean isQuestShown(IQuest quest, UUID uuid, EntityPlayer player) {
        if (quest == null || uuid == null) {
            return false;
        }
        EnumQuestVisibility vis = quest.getProperty(NativeProps.VISIBILITY);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit(player) || vis == EnumQuestVisibility.ALWAYS) {
            return true;
        }
        if (vis == EnumQuestVisibility.HIDDEN) {
            return false;
        }
        if (vis == EnumQuestVisibility.UNLOCKED) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (vis == EnumQuestVisibility.NORMAL) {
            if (quest.isComplete(uuid) || quest.isUnlocked(uuid)) {
                return true;
            }
            for (DBEntry<IQuest> q : QuestDatabase.INSTANCE.bulkLookup(quest.getRequirements())) {
                if (q.getValue().isUnlocked(uuid)) continue;
                return false;
            }
            return true;
        }
        if (vis == EnumQuestVisibility.COMPLETED) {
            return quest.isComplete(uuid);
        }
        if (vis == EnumQuestVisibility.CHAIN) {
            if (quest.getRequirements().length <= 0) {
                return true;
            }
            for (DBEntry<IQuest> q : QuestDatabase.INSTANCE.bulkLookup(quest.getRequirements())) {
                if (q == null) {
                    return true;
                }
                if (!QuestCache.isQuestShown(q.getValue(), uuid, player)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public class QResetTime
    implements Comparable<QResetTime> {
        public final int questID;
        public final long time;

        public QResetTime(int questID, long time) {
            this.questID = questID;
            this.time = time;
        }

        @Override
        public int compareTo(QResetTime o) {
            return Long.compare(o.time, this.time);
        }

        public boolean equals(Object o) {
            if (!(o instanceof QResetTime)) {
                return false;
            }
            return ((QResetTime)o).questID == this.questID;
        }
    }
}

