/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.darkmagic;

import com.google.gson.Gson;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CommonMethodHandles {
    private static final MethodHandle lootTable$poolsGetter;
    private static final MethodHandle lootPool$poolConditionsGetter;
    private static final MethodHandle lootTableManager$GSON_INSTANCEGetter;
    private static final MethodHandle entityLiving$getLootTable;

    public static List<LootPool> getPoolsFromTable(LootTable table) {
        try {
            return lootTable$poolsGetter.invokeExact(table);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not invoke loot table pool getter method handle", t);
        }
    }

    public static List<LootCondition> getConditionsFromPool(LootPool pool) {
        try {
            return lootPool$poolConditionsGetter.invokeExact(pool);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not invoke loot table pool conditions getter method handle", t);
        }
    }

    public static ResourceLocation getEntityLootTable(EntityLiving living) {
        try {
            return entityLiving$getLootTable.invokeExact(living);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not invoke entity loot table getter method handle", t);
        }
    }

    public static Gson getLootTableGSON() {
        try {
            return lootTableManager$GSON_INSTANCEGetter.invokeExact();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not invoke loot table serialiser getter method handle", t);
        }
    }

    static {
        try {
            lootTable$poolsGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c"));
            lootPool$poolConditionsGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186454_b"));
            lootTableManager$GSON_INSTANCEGetter = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(LootTableManager.class, (String)"field_186526_b"));
            entityLiving$getLootTable = MethodHandles.lookup().unreflect(ObfuscationReflectionHelper.findMethod(EntityLiving.class, (String)"func_184647_J", ResourceLocation.class, (Class[])new Class[0]));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize MethodHandles!", e);
        }
    }
}

