/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.Validate;
import reborncore.common.util.StringUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModItems;
import techreborn.utils.TechRebornCreativeTab;

public class DynamicCell
extends Item {
    public static final int CAPACITY = 1000;

    public DynamicCell() {
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77655_b("techreborn.cell");
        this.func_77625_d(64);
        TRRecipeHandler.hideEntry(this);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && ((tag = stack.func_77978_p()).func_186856_d() != 1 || tag.func_74764_b("Fluid"))) {
            NBTTagCompound clearTag = new NBTTagCompound();
            clearTag.func_74782_a("Fluid", (NBTBase)tag.func_74775_l("Fluid"));
            stack.func_77982_d(clearTag);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult result;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K && (result = this.func_77621_a(worldIn, playerIn, true)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = result.func_178782_a();
            IBlockState state = worldIn.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block instanceof IFluidBlock) {
                FluidStack fluid;
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (fluidBlock.canDrain(worldIn, pos) && (fluid = fluidBlock.drain(worldIn, pos, false)) != null && fluid.amount == 1000 && this.tryAddCellToInventory(playerIn, stack, fluid.getFluid())) {
                    fluidBlock.drain(worldIn, pos, true);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (block instanceof BlockStaticLiquid) {
                Fluid fluid;
                Fluid fluid2 = fluid = state.func_185904_a() == Material.field_151587_i ? FluidRegistry.LAVA : FluidRegistry.WATER;
                if (this.tryAddCellToInventory(playerIn, stack, fluid)) {
                    if (fluid != FluidRegistry.WATER) {
                        worldIn.func_175698_g(pos);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            } else {
                ItemStack usedCell = stack.func_77946_l();
                usedCell.func_190920_e(1);
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)usedCell);
                if (fluidHandler != null) {
                    FluidStack fluid = fluidHandler.drain(1000, false);
                    if (fluid != null) {
                        if (FluidUtil.tryPlaceFluid((EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos.func_177972_a(result.field_178784_b), (IFluidHandler)fluidHandler, (FluidStack)fluid)) {
                            stack.func_190918_g(1);
                            playerIn.field_71071_by.func_70441_a(DynamicCell.getEmptyCell(1));
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean tryAddCellToInventory(EntityPlayer player, ItemStack stack, Fluid fluid) {
        if (player.field_71071_by.func_70441_a(DynamicCell.getCellWithFluid(fluid))) {
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)DynamicCell.getEmptyCell(1));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            subItems.add((Object)DynamicCell.getCellWithFluid(fluid));
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = DynamicCell.getFluidHandler(stack).getFluid();
        if (fluidStack == null) {
            return super.func_77653_i(stack);
        }
        return StringUtils.t((String)"item.techreborn.cell.fluid.name").replaceAll("\\$fluid\\$", fluidStack.getLocalizedName());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return DynamicCell.getFluidHandler(stack);
    }

    public static FluidHandler getFluidHandler(ItemStack stack) {
        return new FluidHandler(stack, 1000);
    }

    public static ItemStack getCellWithFluid(Fluid fluid, int stackSize) {
        Validate.notNull((Object)fluid);
        ItemStack stack = new ItemStack((Item)ModItems.CELL);
        DynamicCell.getFluidHandler(stack).fill(new FluidStack(fluid, 1000), true);
        stack.func_190920_e(stackSize);
        return stack;
    }

    public static ItemStack getEmptyCell(int amount) {
        return new ItemStack((Item)ModItems.CELL, amount);
    }

    public static ItemStack getCellWithFluid(Fluid fluid) {
        return DynamicCell.getCellWithFluid(fluid, 1);
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
            FluidStack stack;
            if (container.func_77942_o() && container.func_77978_p().func_74764_b("FluidName") && (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p())) != null) {
                container.func_77982_d(new NBTTagCompound());
                this.fill(stack, true);
            }
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if (resource.amount > this.capacity) {
                resource.amount = this.capacity;
            }
            if (resource.amount != this.capacity) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain > this.capacity) {
                maxDrain = this.capacity;
            }
            if (maxDrain != this.capacity) {
                return null;
            }
            return super.drain(maxDrain, doDrain);
        }

        public ItemStack getContainer() {
            ItemStack cell = this.container.func_77942_o() && this.container.func_77978_p().func_74764_b("Fluid") ? super.getContainer() : new ItemStack((Item)ModItems.CELL, 1);
            return cell;
        }

        protected void setContainerToEmpty() {
            this.container = new ItemStack((Item)ModItems.CELL, 1);
        }
    }
}

