/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.cable;

import java.security.InvalidParameterException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.energy.CapabilityEnergy;
import reborncore.api.ToolManager;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.blocks.cable.EnumCableType;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;
import techreborn.tiles.cable.TileCable;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.utils.damageSources.ElectrialShockSource;

@RebornRegistry(modID="techreborn")
public class BlockCable
extends BlockContainer {
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final IProperty<EnumCableType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumCableType.class);
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionDamage", comment="When true an uninsulated cable will cause damage to entities")
    public static boolean uninsulatedElectrocutionDamage = true;
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionSound", comment="When true an uninsulated cable will create a spark sound when an entity touches it")
    public static boolean uninsulatedElectrocutionSound = true;
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionParticles", comment="When true an uninsulated cable will create a spark when an entity touches it")
    public static boolean uninsulatedElectrocutionParticles = true;

    public BlockCable() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(8.0f);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE, (Comparable)((Object)EnumCableType.COPPER)));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public static ItemStack getCableByName(String name, int count) {
        for (int i = 0; i < EnumCableType.values().length; ++i) {
            if (!EnumCableType.values()[i].func_176610_l().equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.CABLE, count, i);
        }
        throw new InvalidParameterException("The cable " + name + " could not be found.");
    }

    public static ItemStack getCableByName(String name) {
        return BlockCable.getCableByName(name, 1);
    }

    public TileEntity getTileEntitySafely(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return blockAccess.func_175625_s(pos);
    }

    public IProperty<Boolean> getProperty(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return EAST;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCable((EnumCableType)((Object)this.func_176203_a(meta).func_177229_b(TYPE)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            if (state.func_177229_b(TYPE) == EnumCableType.ICOPPER) {
                drops.add((Object)BlockCable.getCableByName("copper", 1));
            } else if (state.func_177229_b(TYPE) == EnumCableType.IGOLD) {
                drops.add((Object)BlockCable.getCableByName("gold", 1));
            } else if (state.func_177229_b(TYPE) == EnumCableType.IHV) {
                drops.add((Object)BlockCable.getCableByName("hv", 1));
            } else {
                super.getDrops(drops, world, pos, state, fortune);
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ((EnumCableType)((Object)state.func_177229_b(TYPE))).getStack();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_177229_b(TYPE) != EnumCableType.GLASSFIBER;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EAST, WEST, NORTH, SOUTH, UP, DOWN, TYPE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumCableType cableType : EnumCableType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, cableType.ordinal()));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCableType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumCableType.values()[meta]));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        float minSize = 0.3125f;
        float maxSize = 0.6875f;
        int thinkness = (int)((EnumCableType)((Object)state.func_177229_b(BlockCable.TYPE))).cableThickness;
        if (thinkness == 6) {
            minSize = 0.35f;
            maxSize = 0.65f;
        }
        float minX = (Boolean)state.func_177229_b((IProperty)WEST) != false ? 0.0f : minSize;
        float minY = (Boolean)state.func_177229_b((IProperty)DOWN) != false ? 0.0f : minSize;
        float minZ = (Boolean)state.func_177229_b((IProperty)NORTH) != false ? 0.0f : minSize;
        float maxX = (Boolean)state.func_177229_b((IProperty)EAST) != false ? 1.0f : maxSize;
        float maxY = (Boolean)state.func_177229_b((IProperty)UP) != false ? 1.0f : maxSize;
        float maxZ = (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 1.0f : maxSize;
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = state;
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.getTileEntitySafely(worldIn, pos.func_177972_a(facing));
            if (tileEntity == null) continue;
            actualState = actualState.func_177226_a(this.getProperty(facing), (Comparable)Boolean.valueOf(tileEntity.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())));
        }
        return actualState;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tileEntity;
        super.func_180634_a(worldIn, pos, state, entity);
        if (((EnumCableType)((Object)state.func_177229_b(BlockCable.TYPE))).canKill && entity instanceof EntityLivingBase && (tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileCable) {
            TileCable tileCable = (TileCable)tileEntity;
            if (tileCable.power != 0) {
                if (uninsulatedElectrocutionDamage) {
                    if (state.func_177229_b(TYPE) == EnumCableType.HV) {
                        entity.func_70015_d(1);
                    }
                    entity.func_70097_a((DamageSource)new ElectrialShockSource(), 1.0f);
                }
                if (uninsulatedElectrocutionSound) {
                    worldIn.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ModSounds.CABLE_SHOCK, SoundCategory.BLOCKS, 0.6f, 1.0f);
                }
                if (uninsulatedElectrocutionParticles) {
                    worldIn.func_175688_a(EnumParticleTypes.CRIT, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

