/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.raytracer.RayTracer;
import morph.avaritia.Avaritia;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.tools.ItemPickaxeInfinity;
import morph.avaritia.util.ToolHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShovelInfinity
extends ItemSpade {
    private static final Item.ToolMaterial TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"INFINITY_SHOVEL", (int)32, (int)9999, (float)9999.0f, (float)7.0f, (int)200);

    public ItemShovelInfinity() {
        super(TOOL_MATERIAL);
        this.func_77655_b("avaritia:infinity_shovel");
        this.setRegistryName("infinity_shovel");
        this.func_77637_a(Avaritia.tab);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("destroyer")) {
            return 5.0f;
        }
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.field_77864_a;
        }
        return Math.max(super.func_150893_a(stack, state), 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTTagCompound tags = stack.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
                stack.func_77982_d(tags);
            }
            tags.func_74757_a("destroyer", !tags.func_74767_n("destroyer"));
            player.func_184609_a(hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        RayTraceResult traceResult;
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("destroyer") && (traceResult = RayTracer.retrace((EntityPlayer)player, (double)10.0, (boolean)true)) != null) {
            this.breakOtherBlock(player, stack, pos, traceResult.field_178784_b);
        }
        return false;
    }

    public void breakOtherBlock(EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing sideHit) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        Material mat = state.func_185904_a();
        if (!ItemPickaxeInfinity.MATERIALS.contains(mat)) {
            return;
        }
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            return;
        }
        boolean doY = sideHit.func_176740_k() != EnumFacing.Axis.Y;
        int range = 8;
        BlockPos min = new BlockPos(-range, doY ? -1 : -range, -range);
        BlockPos max = new BlockPos(range, doY ? range * 2 - 2 : range, range);
        ToolHelper.aoeBlocks(player, stack, world, pos, min, max, null, ItemPickaxeInfinity.MATERIALS, false);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }
}

