/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.machines.IMachineType;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.TileEntityMachine;
import binnie.genetics.machine.inoculator.PackageInoculator;
import binnie.genetics.machine.isolator.PackageIsolator;
import binnie.genetics.machine.polymeriser.PackagePolymeriser;
import binnie.genetics.machine.sequencer.PackageSequencer;
import binnie.genetics.modules.ModuleMachine;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public enum GeneticMachine implements IMachineType
{
    Isolator(PackageIsolator::new),
    Sequencer(PackageSequencer::new),
    Polymeriser(PackagePolymeriser::new),
    Inoculator(PackageInoculator::new);

    private final Supplier<MachinePackage> supplier;

    private GeneticMachine(Supplier<MachinePackage> supplier) {
        this.supplier = supplier;
    }

    @Override
    public Supplier<MachinePackage> getSupplier() {
        return this.supplier;
    }

    public ItemStack get(int i) {
        return new ItemStack((Block)ModuleMachine.getPackageGenetic().getBlock(), i, this.ordinal());
    }

    public static abstract class PackageGeneticBase
    extends MachinePackage {
        private final int colour;

        protected PackageGeneticBase(String uid, int flashColour) {
            super(uid);
            this.colour = flashColour;
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }
    }
}

