/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees.newzealand;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.util.BlockMathHelper;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenPohutukawa2
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA);
    private static final int minBasicCheckHeight = 10;

    public WorldGenPohutukawa2(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int height = 10;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 2 <= worldIn.func_72800_K()) {
            for (int j = y; j < y + 2 + height; ++j) {
                int k = 1;
                if (j == y) {
                    k = 0;
                }
                if (j >= y + 2 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos b1 = new BlockPos.MutableBlockPos();
                for (int l = x - k; l <= x + k && flag; ++l) {
                    for (int i1 = z - k; i1 <= z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)b1.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            boolean canSustainPlant = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if ((canSustainPlant || state.func_177230_c() == Blocks.field_150354_m) && pos.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                if (canSustainPlant) {
                    state.func_177230_c().onPlantGrow(state, worldIn, pos.func_177977_b(), pos);
                }
                this.func_175903_a(worldIn, pos, TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 1, 0), TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 1, 1), TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 0, 1), TRUNK);
                this.func_175903_a(worldIn, pos.func_177984_a(), TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 1, 0).func_177984_a(), TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 1, 1).func_177984_a(), TRUNK);
                this.func_175903_a(worldIn, BlockMathHelper.BlockPosMath.add(pos, 0, 1).func_177984_a(), TRUNK);
                EnumDirection dr1 = EnumDirection.getRandomEnumX(rand);
                EnumDirection dr2 = EnumDirection.getRandomEnumZ(rand);
                this.generateBranch(worldIn, pos.func_177984_a(), rand, dr1, dr2);
                this.generateBranch(worldIn, this.getRandomFalseOrigin(pos.func_177984_a(), rand), rand, dr1.getFullOpposite(), dr2.getFullOpposite());
                for (int i = 0; i < 2 + rand.nextInt(4); ++i) {
                    this.generateBranch(worldIn, this.getRandomOrigin(pos.func_177984_a(), rand), rand);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void generateBranch(World worldIn, BlockPos origin, Random rand, EnumDirection d1in, EnumDirection d2in) {
        EnumDirection d1 = d1in;
        EnumDirection d2 = d2in;
        EnumDirection d3 = EnumDirection.UP;
        int branchLength = 3 + rand.nextInt(3);
        for (int distance = 1; distance <= branchLength; ++distance) {
            int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
            int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
            int yOffset = d3.getYOffset();
            this.func_175903_a(worldIn, origin.func_177982_a(xOffset * distance, yOffset * distance, zOffset * distance), TRUNK.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)d1.getLogAxisOf()));
        }
        int xOffset = d1.getXOffset() + Math.floorDiv(d2.getXOffset(), 2);
        int zOffset = d1.getZOffset() + Math.floorDiv(d2.getZOffset(), 2);
        int yOffset = d3.getYOffset();
        this.generateLeafNode(worldIn, origin.func_177982_a(xOffset * branchLength, yOffset * branchLength, zOffset * branchLength), rand);
    }

    private void generateBranch(World worldIn, BlockPos origin, Random rand) {
        EnumDirection d1 = EnumDirection.getRandomEnumDirectional(rand);
        EnumDirection d2 = d1.getRandomOppAxisEnum(rand);
        this.generateBranch(worldIn, origin, rand, d1, d2);
    }

    private void generateLeafNode(World worldIn, BlockPos pos, Random rand) {
        this.func_175903_a(worldIn, pos.func_177984_a(), this.getLeaves(rand));
        this.func_175903_a(worldIn, pos.func_177982_a(-1, 1, 0), this.getLeaves(rand));
        this.func_175903_a(worldIn, pos.func_177982_a(1, 1, 0), this.getLeaves(rand));
        this.func_175903_a(worldIn, pos.func_177982_a(0, 1, -1), this.getLeaves(rand));
        this.func_175903_a(worldIn, pos.func_177982_a(0, 1, 1), this.getLeaves(rand));
        for (int y = 0; y > -2; --y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && z == 0) continue;
                    this.func_175903_a(worldIn, pos.func_177982_a(x, y, z), this.getLeaves(rand));
                }
                if (Math.abs(x) >= 2) continue;
                this.func_175903_a(worldIn, pos.func_177982_a(x, y, -2), this.getLeaves(rand));
                this.func_175903_a(worldIn, pos.func_177982_a(x, y, 2), this.getLeaves(rand));
            }
        }
    }

    private IBlockState getLeaves(Random rand) {
        switch (rand.nextInt(6)) {
            case 0: 
            case 1: {
                return ModBlocks.LEAVES_POHUTUKAWA_FLOWER.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
            }
            case 2: {
                return ModBlocks.LEAVES_POHUTUKAWA.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
            }
        }
        return ModBlocks.LEAVES_POHUTUKAWA_BUD.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    }

    private BlockPos getRandomOrigin(BlockPos pos, Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return BlockMathHelper.BlockPosMath.add(pos, 0, 0);
            }
            case 1: {
                return BlockMathHelper.BlockPosMath.add(pos, 1, 0);
            }
            case 2: {
                return BlockMathHelper.BlockPosMath.add(pos, 1, 1);
            }
        }
        return BlockMathHelper.BlockPosMath.add(pos, 0, 1);
    }

    private BlockPos getRandomFalseOrigin(BlockPos pos, Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BlockMathHelper.BlockPosMath.add(pos, 1, 0);
            }
            case 1: {
                return BlockMathHelper.BlockPosMath.add(pos, 1, 1);
            }
        }
        return BlockMathHelper.BlockPosMath.add(pos, 0, 1);
    }
}

