/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.world.trees;

import java.util.Random;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import valoeghese.valoeghesesbe.world.trees.enumTypes.EnumDirection;

public class WorldGenStrippedOak
extends WorldGenAbstractTree {
    private static final int minBasicHeight = 6;
    private static final IBlockState TRUNK = Blocks.field_150364_r.func_176223_P();

    public WorldGenStrippedOak(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int theight = rand.nextInt(6) + 6 + 1;
        int trunk = rand.nextInt(2);
        int height = theight + trunk;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 2 <= worldIn.func_72800_K()) {
            for (int j = y; j < y + 2 + height; ++j) {
                int k = 1;
                if (j == y) {
                    k = 0;
                }
                if (j >= y + 2 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos b1 = new BlockPos.MutableBlockPos();
                for (int l = x - k; l <= x + k && flag; ++l) {
                    for (int i1 = z - k; i1 <= z + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)b1.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
            boolean canBlockSustainTree = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (canBlockSustainTree && y < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, pos.func_177977_b(), pos);
                for (int lHeight = 0; lHeight <= height; ++lHeight) {
                    BlockPos up = pos.func_177981_b(lHeight);
                    IBlockState lState = worldIn.func_180495_p(up);
                    if (lHeight > trunk && lHeight < height - 1 && rand.nextInt(4) == 0) {
                        this.generateBranch(worldIn, rand, new BlockPos(x, y + lHeight, z));
                    }
                    this.func_175903_a(worldIn, pos.func_177981_b(lHeight), TRUNK);
                }
            }
            return true;
        }
        return true;
    }

    private void generateBranch(World worldIn, Random rand, BlockPos blockPos) {
        EnumDirection out = EnumDirection.getRandomEnumDirectional(rand);
        int branchLength = rand.nextInt(4);
        for (int dist = 1; dist < branchLength; ++dist) {
            int up = rand.nextInt(3);
            if (up == 2) {
                up = 0;
            }
            this.func_175903_a(worldIn, blockPos.func_177982_a(out.getXOffset() * dist, up, out.getZOffset() * dist), TRUNK);
        }
        if (rand.nextInt(4) == 0) {
            this.func_175903_a(worldIn, blockPos.func_177982_a(out.getXOffset() * branchLength, 0, out.getZOffset() * branchLength), Blocks.field_150362_t.func_176223_P());
        }
    }
}

