/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.functional.tree;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.init.ModBlocks;
import valoeghese.valoeghesesbe.init.ModItems;
import valoeghese.valoeghesesbe.util.IHasModel;

public class BlockLeavesPeach
extends BlockLeaves
implements IHasModel {
    public final EnumGenotype VARIANT;
    public static final int MUTATION_CHANCE = 10;

    public int func_149745_a(Random rand) {
        return rand.nextInt(15) == 0 ? 1 : 0;
    }

    public BlockLeavesPeach(String name, EnumGenotype variant) {
        this.VARIANT = variant;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(Main.tabWorld);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)));
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 200;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Genotype unknown");
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int mut = rand.nextInt(10);
        if (mut == 0) {
            return BlockLeavesPeach.getSapling(this.VARIANT.mutate(rand));
        }
        return BlockLeavesPeach.getSapling(this.VARIANT);
    }

    public static Item getSapling(EnumGenotype variant) {
        Block block = variant == EnumGenotype.PP ? ModBlocks.SAPLING_PEACH_PP : (variant == EnumGenotype.Pp ? ModBlocks.SAPLING_PEACH_Pp : (variant == EnumGenotype.pP ? ModBlocks.SAPLING_PEACH_pP : ModBlocks.SAPLING_PEACH_pp));
        return Item.func_150898_a((Block)block);
    }

    public int func_180651_a(IBlockState state) {
        return super.func_180651_a(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == Items.field_190931_a) continue;
            drops.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (world instanceof World && rand.nextInt(5) == 0) {
            this.func_176234_a((World)world, pos, state, 5);
        }
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 2;
        }
        return i;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.field_73012_v.nextInt(chance) == 0) {
            if (this.VARIANT == EnumGenotype.pp) {
                BlockLeavesPeach.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.NECTARINE));
            } else {
                BlockLeavesPeach.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(ModItems.PEACH));
            }
        }
    }

    protected int func_176232_d(IBlockState state) {
        return 20;
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 1) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 2) > 0));
        return state;
    }

    @Override
    public void registerModels() {
        Main.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public static Block getBlockByGenotype(EnumGenotype genotype) {
        switch (genotype) {
            case PP: {
                return ModBlocks.LEAVES_PEACH_PP;
            }
            case Pp: {
                return ModBlocks.LEAVES_PEACH_Pp;
            }
            case pP: {
                return ModBlocks.LEAVES_PEACH_pP;
            }
            case pp: {
                return ModBlocks.LEAVES_PEACH_pp;
            }
        }
        return ModBlocks.LEAVES_PEACH_PP;
    }

    public static enum EnumGenotype implements IStringSerializable
    {
        PP(0, "homozygous_dominant", Allele.DOM, Allele.DOM),
        Pp(1, "heterozygous_0", Allele.DOM, Allele.REC),
        pP(2, "heterozygous_1", Allele.REC, Allele.DOM),
        pp(3, "homozygous_recessive", Allele.REC, Allele.REC);

        private static final EnumGenotype[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final Allele allele0;
        private final Allele allele1;

        private EnumGenotype(int metaIn, String nameIn, Allele ... alleles) {
            this(metaIn, nameIn, nameIn, alleles);
        }

        private EnumGenotype(int metaIn, String nameIn, String unlocalizedNameIn, Allele[] alleles) {
            this.meta = metaIn;
            this.name = nameIn;
            this.unlocalizedName = unlocalizedNameIn;
            this.allele0 = alleles[0];
            this.allele1 = alleles[1];
        }

        public static EnumGenotype getGenotype(Allele allele0, Allele allele1) {
            if (allele0 == Allele.DOM) {
                if (allele1 == Allele.DOM) {
                    return PP;
                }
                return Pp;
            }
            if (allele1 == Allele.DOM) {
                return pP;
            }
            return pp;
        }

        public EnumGenotype mutate(Random rand) {
            Allele a0 = this.allele0;
            Allele a1 = this.allele1;
            if (rand.nextBoolean()) {
                a0 = a0.getOpposite();
            } else {
                a1 = a1.getOpposite();
            }
            return EnumGenotype.getGenotype(a0, a1);
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumGenotype byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumGenotype[EnumGenotype.values().length];
            EnumGenotype[] enumGenotypeArray = EnumGenotype.values();
            int n = enumGenotypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumGenotype BlockLeavesPeach$EnumGenotype;
                EnumGenotype.META_LOOKUP[BlockLeavesPeach$EnumGenotype.getMetadata()] = BlockLeavesPeach$EnumGenotype = enumGenotypeArray[i];
            }
        }

        private static enum Allele {
            DOM,
            REC;


            public Allele getOpposite() {
                if (this == DOM) {
                    return REC;
                }
                return DOM;
            }
        }
    }
}

