/*
 * Decompiled with CFR 0.152.
 */
package valoeghese.valoeghesesbe.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import valoeghese.valoeghesesbe.Main;
import valoeghese.valoeghesesbe.blocks.BlockBase;

public class BlockStairsBase
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumHalf.class);
    public static final PropertyEnum<EnumShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumShape.class);
    protected static final AxisAlignedBB AABB_SLAB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_WEST = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_EAST = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_TOP_NORTH = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_TOP_SOUTH = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_NW = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_NE = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_TOP_SW = new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_TOP_SE = new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_SLAB_BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_QTR_BOT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_QTR_BOT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5);
    protected static final AxisAlignedBB AABB_OCT_BOT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0);
    protected static final AxisAlignedBB AABB_OCT_BOT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0);

    public BlockStairsBase(String name) {
        super(name, Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(HALF, (Comparable)((Object)EnumHalf.BOTTOM)).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.STRAIGHT)));
        this.func_149711_c(2.0f);
        this.func_149752_b(0.3f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149713_g(255);
        this.func_149647_a(Main.tabMisc);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockStairsBase.getCollisionBoxList(state)) {
            BlockStairsBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        boolean flag = bstate.func_177229_b(HALF) == EnumHalf.TOP;
        list.add(flag ? AABB_SLAB_TOP : AABB_SLAB_BOTTOM);
        EnumShape blockstairs$enumshape = (EnumShape)((Object)bstate.func_177229_b(SHAPE));
        if (blockstairs$enumshape == EnumShape.STRAIGHT || blockstairs$enumshape == EnumShape.INNER_LEFT || blockstairs$enumshape == EnumShape.INNER_RIGHT) {
            list.add(BlockStairsBase.getCollQuarterBlock(bstate));
        }
        if (blockstairs$enumshape != EnumShape.STRAIGHT) {
            list.add(BlockStairsBase.getCollEighthBlock(bstate));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        boolean flag = bstate.func_177229_b(HALF) == EnumHalf.TOP;
        switch ((EnumFacing)bstate.func_177229_b((IProperty)FACING)) {
            default: {
                return flag ? AABB_QTR_BOT_NORTH : AABB_QTR_TOP_NORTH;
            }
            case SOUTH: {
                return flag ? AABB_QTR_BOT_SOUTH : AABB_QTR_TOP_SOUTH;
            }
            case WEST: {
                return flag ? AABB_QTR_BOT_WEST : AABB_QTR_TOP_WEST;
            }
            case EAST: 
        }
        return flag ? AABB_QTR_BOT_EAST : AABB_QTR_TOP_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)bstate.func_177229_b((IProperty)FACING);
        switch ((EnumShape)((Object)bstate.func_177229_b(SHAPE))) {
            default: {
                enumfacing1 = enumfacing;
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.func_176735_f();
            }
        }
        boolean flag = bstate.func_177229_b(HALF) == EnumHalf.TOP;
        switch (enumfacing1) {
            default: {
                return flag ? AABB_OCT_BOT_NW : AABB_OCT_TOP_NW;
            }
            case SOUTH: {
                return flag ? AABB_OCT_BOT_SE : AABB_OCT_TOP_SE;
            }
            case WEST: {
                return flag ? AABB_OCT_BOT_SW : AABB_OCT_TOP_SW;
            }
            case EAST: 
        }
        return flag ? AABB_OCT_BOT_NE : AABB_OCT_TOP_NE;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        state = this.func_176221_a(state, worldIn, pos);
        if (face.func_176740_k() == EnumFacing.Axis.Y) {
            return face == EnumFacing.UP == (state.func_177229_b(HALF) == EnumHalf.TOP) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        EnumShape blockstairs$enumshape = (EnumShape)((Object)state.func_177229_b(SHAPE));
        if (blockstairs$enumshape != EnumShape.OUTER_LEFT && blockstairs$enumshape != EnumShape.OUTER_RIGHT) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            switch (blockstairs$enumshape) {
                case INNER_RIGHT: {
                    return enumfacing != face && enumfacing != face.func_176735_f() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case INNER_LEFT: {
                    return enumfacing != face && enumfacing != face.func_176746_e() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case STRAIGHT: {
                    return enumfacing == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        super.func_180649_a(worldIn, pos, playerIn);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return super.func_185484_c(state, source, pos);
    }

    public float func_149638_a(Entity exploder) {
        return super.func_149638_a(exploder);
    }

    public int func_149738_a(World worldIn) {
        return super.func_149738_a(worldIn);
    }

    public Vec3d func_176197_a(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return super.func_176197_a(worldIn, pos, entityIn, motion);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return super.func_180664_k();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return super.func_180640_a(state, worldIn, pos);
    }

    public boolean func_149703_v() {
        return super.func_149703_v();
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return super.func_176209_a(state, hitIfLiquid);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_189540_a(state, worldIn, pos, Blocks.field_150350_a, pos);
        super.func_176213_c(worldIn, pos, super.func_176223_P());
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, super.func_176223_P());
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return super.func_180639_a(worldIn, pos, super.func_176223_P(), playerIn, hand, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(HALF) == EnumHalf.TOP;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_180659_g(super.func_176223_P(), worldIn, pos);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.STRAIGHT));
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumHalf.BOTTOM)) : iblockstate.func_177226_a(HALF, (Comparable)((Object)EnumHalf.TOP));
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : BlockStairsBase.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)((meta & 4) > 0 ? EnumHalf.TOP : EnumHalf.BOTTOM)));
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (state.func_177229_b(HALF) == EnumHalf.TOP) {
            i |= 4;
        }
        return i |= 5 - ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)BlockStairsBase.getStairsShape(state, worldIn, pos)));
    }

    private static EnumShape getStairsShape(IBlockState p_185706_0_, IBlockAccess p_185706_1_, BlockPos p_185706_2_) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING);
        IBlockState iblockstate = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing));
        if (BlockStairsBase.isBlockStairs(iblockstate) && p_185706_0_.func_177229_b(HALF) == iblockstate.func_177229_b(HALF) && (enumfacing1 = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING)).func_176740_k() && BlockStairsBase.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing1.func_176734_d())) {
            if (enumfacing1 == enumfacing.func_176735_f()) {
                return EnumShape.OUTER_LEFT;
            }
            return EnumShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = p_185706_1_.func_180495_p(p_185706_2_.func_177972_a(enumfacing.func_176734_d()));
        if (BlockStairsBase.isBlockStairs(iblockstate1) && p_185706_0_.func_177229_b(HALF) == iblockstate1.func_177229_b(HALF) && (enumfacing2 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)p_185706_0_.func_177229_b((IProperty)FACING)).func_176740_k() && BlockStairsBase.isDifferentStairs(p_185706_0_, p_185706_1_, p_185706_2_, enumfacing2)) {
            if (enumfacing2 == enumfacing.func_176735_f()) {
                return EnumShape.INNER_LEFT;
            }
            return EnumShape.INNER_RIGHT;
        }
        return EnumShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState p_185704_0_, IBlockAccess p_185704_1_, BlockPos p_185704_2_, EnumFacing p_185704_3_) {
        IBlockState iblockstate = p_185704_1_.func_180495_p(p_185704_2_.func_177972_a(p_185704_3_));
        return !BlockStairsBase.isBlockStairs(iblockstate) || iblockstate.func_177229_b((IProperty)FACING) != p_185704_0_.func_177229_b((IProperty)FACING) || iblockstate.func_177229_b(HALF) != p_185704_0_.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockStairsBase;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumShape blockstairs$enumshape = (EnumShape)((Object)state.func_177229_b(SHAPE));
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.INNER_LEFT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.INNER_RIGHT));
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (blockstairs$enumshape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.INNER_RIGHT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumShape.INNER_LEFT));
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HALF, SHAPE});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (ForgeModContainer.disableStairSlabCulling) {
            return super.doesSideBlockRendering(state, world, pos, face);
        }
        if (state.func_185914_p()) {
            return true;
        }
        state = this.func_176221_a(state, world, pos);
        EnumHalf half = (EnumHalf)((Object)state.func_177229_b(HALF));
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumShape shape = (EnumShape)((Object)state.func_177229_b(SHAPE));
        if (face == EnumFacing.UP) {
            return half == EnumHalf.TOP;
        }
        if (face == EnumFacing.DOWN) {
            return half == EnumHalf.BOTTOM;
        }
        if (shape == EnumShape.OUTER_LEFT || shape == EnumShape.OUTER_RIGHT) {
            return false;
        }
        if (face == side) {
            return true;
        }
        if (shape == EnumShape.INNER_LEFT && face.func_176746_e() == side) {
            return true;
        }
        return shape == EnumShape.INNER_RIGHT && face.func_176735_f() == side;
    }

    public static enum EnumShape implements IStringSerializable
    {
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private EnumShape(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private EnumHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

