/*
 * Decompiled with CFR 0.152.
 */
package com.viesis.viescraft.client;

import com.viesis.viescraft.api.BlocksVC;
import com.viesis.viescraft.init.InitBlocksVC;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="vc")
public final class InitBlocksVCRender
extends BlocksVC {
    public static final InitBlocksVCRender INSTANCE = new InitBlocksVCRender();
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
    }

    private void registerBlockModels() {
        InitBlocksVC.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerItemModels() {
        InitBlocksVC.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, item.getRegistryName().toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, MeshDefinitionFix.create(stack -> fullModelLocation));
    }

    public void registerRender(Block block) {
        Item item = Item.func_150898_a((Block)block);
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    public void registerRender(Block block, int meta, String file) {
        Item item = Item.func_150898_a((Block)block);
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    static interface MeshDefinitionFix
    extends ItemMeshDefinition {
        public ModelResourceLocation getLocation(ItemStack var1);

        public static ItemMeshDefinition create(MeshDefinitionFix lambda) {
            return lambda;
        }

        default public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.getLocation(stack);
        }
    }
}

