/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.HashedItem;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public final class InventoryUtils {
    public static final int[] EMPTY = new int[0];

    public static int[] getIntRange(int start, int end) {
        int[] ret = new int[1 + end - start];
        for (int i = start; i <= end; ++i) {
            ret[i - start] = i;
        }
        return ret;
    }

    public static TransitRequest.TransitResponse putStackInInventory(TileEntity tile, TransitRequest request, EnumFacing side, boolean force) {
        if (force && tile instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tile).sendHome(request.getSingleStack());
        }
        for (Map.Entry<HashedItem, Pair<Integer, Map<Integer, Integer>>> requestEntry : request.getItemMap().entrySet()) {
            ItemStack origInsert = StackUtils.size(requestEntry.getKey().getStack(), (Integer)requestEntry.getValue().getLeft());
            ItemStack toInsert = origInsert.func_77946_l();
            if (!InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
                return TransitRequest.TransitResponse.EMPTY;
            }
            IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!inventory.isItemValid(i, toInsert) || !(toInsert = inventory.insertItem(i, toInsert, false)).func_190926_b()) continue;
                return new TransitRequest.TransitResponse(origInsert, (Map)requestEntry.getValue().getRight());
            }
            if (!TransporterManager.didEmit(origInsert, toInsert)) continue;
            return new TransitRequest.TransitResponse(TransporterManager.getToUse(origInsert, toInsert), (Map)requestEntry.getValue().getRight());
        }
        return TransitRequest.TransitResponse.EMPTY;
    }

    public static boolean areItemsStackable(ItemStack toInsert, ItemStack inSlot) {
        if (toInsert.func_190926_b() || inSlot.func_190926_b()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)toInsert);
    }

    public static InvStack takeDefinedItem(TileEntity tile, EnumFacing side, ItemStack type, int min, int max) {
        InvStack ret = new InvStack(tile, side.func_176734_d());
        if (!InventoryUtils.isItemHandler(tile, side.func_176734_d())) {
            return null;
        }
        IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = inventory.extractItem(i, max, true);
            if (stack.func_190926_b() || !StackUtils.equalsWildcardWithNBT(stack, type)) continue;
            int current = ret.getStack().func_190916_E();
            if (current + stack.func_190916_E() <= max) {
                ret.appendStack(i, stack.func_77946_l());
            } else {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(max - current);
                ret.appendStack(i, copy);
            }
            if (ret.getStack().func_190926_b() || ret.getStack().func_190916_E() != max) continue;
            return ret;
        }
        if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min) {
            return ret;
        }
        return null;
    }

    public static boolean canInsert(TileEntity tileEntity, EnumColor color, ItemStack itemStack, EnumFacing side, boolean force) {
        ISideConfiguration config;
        if (force && tileEntity instanceof TileEntityLogisticalSorter) {
            return ((TileEntityLogisticalSorter)tileEntity).canSendHome(itemStack);
        }
        if (!force && tileEntity instanceof ISideConfiguration && (config = (ISideConfiguration)tileEntity).getEjector().hasStrictInput()) {
            EnumFacing tileSide = config.getOrientation();
            EnumColor configColor = config.getEjector().getInputColor(MekanismUtils.getBaseOrientation(side, tileSide).func_176734_d());
            if (configColor != null && configColor != color) {
                return false;
            }
        }
        if (!InventoryUtils.isItemHandler(tileEntity, side.func_176734_d())) {
            return false;
        }
        IItemHandler inventory = InventoryUtils.getItemHandler(tileEntity, side.func_176734_d());
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack rejects;
            if (!inventory.isItemValid(i, itemStack) || !TransporterManager.didEmit(itemStack, rejects = inventory.insertItem(i, itemStack, true))) continue;
            return true;
        }
        return false;
    }

    public static boolean assertItemHandler(String desc, TileEntity tileEntity, EnumFacing side) {
        if (!InventoryUtils.isItemHandler(tileEntity, side)) {
            Mekanism.logger.warn("'" + desc + "' was wrapped around a non-IItemHandler inventory. This should not happen!");
            if (tileEntity == null) {
                Mekanism.logger.warn(" - null tile");
            } else {
                Mekanism.logger.warn(" - details: " + tileEntity + " " + tileEntity.func_174877_v());
            }
            return false;
        }
        return true;
    }

    public static boolean isItemHandler(TileEntity tile, EnumFacing side) {
        return CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        return (IItemHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static boolean canStack(ItemStack stack1, ItemStack stack2) {
        return stack1.func_190926_b() || stack2.func_190926_b() || stack1.func_77973_b() == stack2.func_77973_b() && (!stack2.func_77981_g() || stack2.func_77952_i() == stack1.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack2, (ItemStack)stack1) && stack1.func_77985_e();
    }
}

