/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.function.Consumer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class CapabilityUtils {
    public static boolean hasCapability(ICapabilityProvider provider, Capability<?> cap, EnumFacing side) {
        if (provider == null || cap == null) {
            return false;
        }
        return provider.hasCapability(cap, side);
    }

    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> cap, EnumFacing side) {
        if (provider == null || cap == null) {
            return null;
        }
        return (T)provider.getCapability(cap, side);
    }

    public static <T> OptionalCapability withCapability(ICapabilityProvider provider, Capability<T> cap, EnumFacing side, Consumer<T> consumer) {
        return new OptionalCapability(provider).orElseWith(cap, side, consumer);
    }

    public static <T> OptionalCapability withCapability(boolean testResult, ICapabilityProvider provider, Capability<T> cap, EnumFacing side, Consumer<T> consumer) {
        return new OptionalCapability(provider).orElseWith(testResult, cap, side, consumer);
    }

    public static class NoOpOptionalCapability
    extends OptionalCapability {
        public static final NoOpOptionalCapability INSTANCE = new NoOpOptionalCapability();

        private NoOpOptionalCapability() {
            super(null);
        }

        @Override
        public <T> OptionalCapability orElseWith(Capability<T> capability, EnumFacing side, Consumer<T> consumer) {
            return this;
        }

        @Override
        public <T> OptionalCapability orElseWith(boolean testResult, Capability<T> capability, EnumFacing side, Consumer<T> consumer) {
            return this;
        }
    }

    public static class OptionalCapability {
        private final ICapabilityProvider provider;

        OptionalCapability(ICapabilityProvider provider) {
            this.provider = provider;
        }

        public <T> OptionalCapability orElseWith(Capability<T> capability, EnumFacing side, Consumer<T> consumer) {
            Object cap = this.provider.getCapability(capability, side);
            if (cap != null) {
                consumer.accept(cap);
                return NoOpOptionalCapability.INSTANCE;
            }
            return this;
        }

        public <T> OptionalCapability orElseWith(boolean testResult, Capability<T> capability, EnumFacing side, Consumer<T> consumer) {
            if (!testResult) {
                return this;
            }
            return this.orElseWith(capability, side, consumer);
        }
    }
}

