/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.filter.GuiItemStackFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMItemStackFilter
extends GuiItemStackFilter<MItemStackFilter, TileEntityDigitalMiner> {
    public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tile, int index) {
        super(player, tile);
        this.origFilter = (MItemStackFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index);
        this.filter = ((MItemStackFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index)).clone();
    }

    public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new MItemStackFilter();
    }

    @Override
    protected void addButtons(int guiWidth, int guiHeight) {
        this.field_146292_n.add(new GuiButton(0, guiWidth + 27, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (!((MItemStackFilter)this.filter).itemType.func_190926_b()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.itemFilter.noItem");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 0, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.itemFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.details") + ":", 35, 32, 52480);
        if (!((MItemStackFilter)this.filter).itemType.func_190926_b()) {
            this.renderScaledText(((MItemStackFilter)this.filter).itemType.func_82833_r(), 35, 41, 52480, 107);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(((MItemStackFilter)this.filter).itemType, 12, 19);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        if (!((MItemStackFilter)this.filter).replaceStack.func_190926_b()) {
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(((MItemStackFilter)this.filter).replaceStack, 149, 19);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.requireReplace") + ": " + LangUtils.transYesNo(((MItemStackFilter)this.filter).requireStack), xAxis, yAxis);
        }
        if (xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.fuzzyMode") + ": " + LangUtils.transYesNo(((MItemStackFilter)this.filter).fuzzy), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int y;
        int x;
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59) {
            this.func_73729_b(guiWidth + 148, guiHeight + 45, 199, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 148, guiHeight + 45, 199, 14, 14, 14);
        }
        if (xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59) {
            this.func_73729_b(guiWidth + 15, guiHeight + 45, 213, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 15, guiHeight + 45, 213, 14, 14, 14);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            x = guiWidth + 12;
            y = guiHeight + 19;
            this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        if (xAxis >= 149 && xAxis <= 165 && yAxis >= 19 && yAxis <= 35) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            x = guiWidth + 149;
            y = guiHeight + 19;
            this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 5 : 0, 0, 0));
            }
            if (xAxis >= 148 && xAxis <= 162 && yAxis >= 45 && yAxis <= 59) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = ((MItemStackFilter)this.filter).requireStack = !((MItemStackFilter)this.filter).requireStack;
            }
            if (xAxis >= 15 && xAxis <= 29 && yAxis >= 45 && yAxis <= 59) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = ((MItemStackFilter)this.filter).fuzzy = !((MItemStackFilter)this.filter).fuzzy;
            }
            if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                    if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                        ((MItemStackFilter)this.filter).itemType = stack.func_77946_l();
                        ((MItemStackFilter)this.filter).itemType.func_190920_e(1);
                    }
                } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                    ((MItemStackFilter)this.filter).itemType = ItemStack.field_190927_a;
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
            if (xAxis >= 149 && xAxis <= 165 && yAxis >= 19 && yAxis <= 35) {
                boolean doNull = false;
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                ItemStack toUse = ItemStack.field_190927_a;
                if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                    if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                        toUse = stack.func_77946_l();
                        toUse.func_190920_e(1);
                    }
                } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                    doNull = true;
                }
                if (!toUse.func_190926_b() || doNull) {
                    ((MItemStackFilter)this.filter).replaceStack = toUse;
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiMItemStackFilter.png");
    }
}

