/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone;

import aroma1997.backup.common.Reference;
import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.plugin.PluginLoader;
import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.common.util.Util;
import aroma1997.backup.standalone.StandaloneEnv;
import aroma1997.backup.standalone.command.CommandRegistry;
import aroma1997.backup.standalone.commands.CommandUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main {
    public static StandaloneEnv env;

    public static void main(String[] args) {
        IOHelper.printUserOut("Loading standalone aromabackup Version " + Reference.VERSION + ".");
        Main.load();
        IOHelper.printUserOut("Type help to see a list of available commands.");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                CommandRegistry.getInstance().execute(CommandRegistry.splitIntoArgs(line));
            }
        }
        catch (IOException e) {
            IOHelper.printError("Stopped with an exception.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void load() {
        env = new StandaloneEnv();
        CommandUtil.setupCommands();
        Util.registerInternalCompressions();
        PluginLoader.load();
        IOHelper.printUserOut("Loading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            IOHelper.printUserOut("Loading module \"" + plugin.getName() + "\".");
            plugin.load();
        }
        IOHelper.printUserOut("Postloading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            IOHelper.printUserOut("Postloading module \"" + plugin.getName() + "\".");
            plugin.postLoad();
        }
        IOHelper.printUserOut("Done loading modules.");
    }
}

