/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.info;

import aroma1997.backup.common.compression.BackupHelper;
import aroma1997.backup.common.compression.CompressionHelper;
import aroma1997.backup.common.info.ExistingBackupInfo;
import aroma1997.backup.common.util.Environment;
import aroma1997.backup.common.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BackupInfoUtil {
    private BackupInfoUtil() {
    }

    public static boolean isBackup(File file) throws IOException {
        Environment.getEnv().logDebug("Trying to see if " + file.getAbsolutePath() + " is a backup.");
        boolean b = file.isFile() && file.exists() && BackupHelper.getCompression(file) != null;
        Environment.getEnv().logDebug("Result:" + b + " " + file.exists() + " " + file.isFile() + " " + Util.getExtension(file.getName()) + " " + CompressionHelper.getCompression(file.getName()) + " " + CompressionHelper.getRegisteredCompressions());
        return b;
    }

    public static List<ExistingBackupInfo> listBackups(File path) throws IOException {
        if (!path.exists() || !path.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<ExistingBackupInfo> list = new ArrayList<ExistingBackupInfo>();
        BackupInfoUtil.addToList(path, list);
        return list;
    }

    public static List<ExistingBackupInfo> listBackupsForWorld(File path, String world) throws IOException {
        List<ExistingBackupInfo> list = BackupInfoUtil.listBackups(path);
        Iterator<ExistingBackupInfo> iter = list.iterator();
        while (iter.hasNext()) {
            ExistingBackupInfo info = iter.next();
            if (info.getWorld().equalsIgnoreCase(world)) continue;
            iter.remove();
        }
        return list;
    }

    private static void addToList(File dir, List<ExistingBackupInfo> list) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isFile() && BackupInfoUtil.isBackup(file)) {
                list.add(new ExistingBackupInfo(file));
            }
            if (!file.isDirectory()) continue;
            BackupInfoUtil.addToList(file, list);
        }
    }

    public static ExistingBackupInfo getNextParentFor(File dir, String worldName) throws IOException {
        List<ExistingBackupInfo> info = BackupInfoUtil.listBackupsForWorld(dir, worldName);
        if (info.isEmpty()) {
            return null;
        }
        return Collections.max(info);
    }
}

