/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.world.FairyRingGenerator;

public class FairyRings
extends Feature {
    private static final Pattern BLOCKSTATE_PARSER = Pattern.compile("^(\\D+?):(\\d+)$");
    public static double forestChance;
    public static double plainsChance;
    public static DimensionConfig dimensions;
    public static List<IBlockState> ores;
    private static boolean initialized;
    public static String[] oresArr;

    @Override
    public void setupConfig() {
        forestChance = this.loadLegacyPropChance("Forest Percentage Chance", "Forest Chance", "", 0.00625);
        plainsChance = this.loadLegacyPropChance("Plains Percentage Chance", "Plains Chance", "", 0.0025);
        dimensions = new DimensionConfig(this.configCategory, "0");
        oresArr = this.loadPropStringList("Spawnable Ores", "", new String[]{Objects.toString(Blocks.field_150412_bA.getRegistryName()), Objects.toString(Blocks.field_150482_ag.getRegistryName())});
        if (initialized) {
            this.loadOres();
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FairyRingGenerator(), (int)5);
    }

    @Override
    public void postInit() {
        this.loadOres();
    }

    private void loadOres() {
        ores = new ArrayList<IBlockState>(oresArr.length);
        for (String s : oresArr) {
            Block b;
            int meta = 0;
            Matcher m = BLOCKSTATE_PARSER.matcher(s);
            if (m.matches()) {
                s = m.group(1);
                meta = Integer.parseInt(m.group(2));
            }
            if ((b = Block.func_149684_b((String)s)) == null) {
                new IllegalArgumentException("Block " + s + " does not exist!").printStackTrace();
                continue;
            }
            ores.add(b.func_176203_a(meta));
        }
        initialized = true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        initialized = false;
    }
}

