/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.util;

import com.teamacronymcoders.base.Base;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ColourHelper {
    public static int getColour(InputStream stream) {
        try {
            ImageInputStream is = ImageIO.createImageInputStream(stream);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(is);
            if (!iter.hasNext()) {
                Base.instance.getLogger().error("Cannot load the specified stream: " + stream);
            }
            ImageReader imageReader = iter.next();
            imageReader.setInput(is);
            Image img = imageReader.read(0).getScaledInstance(1, 1, 16);
            BufferedImage image = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            Graphics2D bGr = image.createGraphics();
            bGr.drawImage(img, 0, 0, null);
            bGr.dispose();
            int height = image.getHeight();
            int width = image.getWidth();
            HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    int rgb = image.getRGB(i, j);
                    Integer counter = (Integer)m.get(rgb);
                    if (counter == null) {
                        counter = 0;
                    }
                    counter = counter + 1;
                    m.put(rgb, counter);
                }
            }
            return Integer.decode("0x" + ColourHelper.getMostCommonColour(m));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0xFFFFFF;
        }
    }

    public static String getMostCommonColour(Map map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, (o1, o2) -> ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue()));
        if (list.size() == 0) {
            return "FFFFFF";
        }
        Map.Entry me = (Map.Entry)list.get(list.size() - 1);
        int[] rgb = ColourHelper.getRGBArr((Integer)me.getKey());
        return String.format("%s%s%s", Integer.toHexString(rgb[0]), Integer.toHexString(rgb[1]), Integer.toHexString(rgb[2]));
    }

    public static int[] getRGBArr(int pixel) {
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new int[]{red, green, blue};
    }
}

