/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.proxies;

import com.teamacronymcoders.base.client.ClientHelper;
import com.teamacronymcoders.base.client.models.IHasModel;
import com.teamacronymcoders.base.client.models.handler.ModelHandler;
import com.teamacronymcoders.base.client.models.sided.ModelLoaderSidedBlock;
import com.teamacronymcoders.base.modulesystem.IModule;
import com.teamacronymcoders.base.modulesystem.ModuleHandler;
import com.teamacronymcoders.base.modulesystem.proxies.IModuleProxy;
import com.teamacronymcoders.base.proxies.LibCommonProxy;
import com.teamacronymcoders.base.registrysystem.pieces.RegistrySide;
import com.teamacronymcoders.base.renderer.entity.loader.EntityRendererLoader;
import com.teamacronymcoders.base.util.files.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class LibClientProxy
extends LibCommonProxy {
    private static ResourceLoader resourceLoader;
    private ModelHandler modelHandler;

    @Override
    public void addOBJDomain() {
        OBJLoader.INSTANCE.addDomain(this.getMod().getID());
    }

    @Override
    public void addSidedBlockDomain() {
        ModelLoaderSidedBlock.getInstance().addDomain(this.getMod().getID());
    }

    @Override
    public void setAllItemModels(IHasModel model) {
        this.getModelHandler().registerModels(model);
    }

    @Override
    public void registerFluidModel(Block fluidBlock, ResourceLocation resourceLocation) {
        Item fluidItem = Item.func_150898_a((Block)fluidBlock);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation(resourceLocation, "normal");
        ModelBakery.registerItemVariants((Item)fluidItem, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)fluidItem, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)fluidBlock, (IStateMapper)new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
                return modelResourceLocation;
            }
        });
    }

    @Override
    public RegistrySide getRegistrySide() {
        return RegistrySide.CLIENT;
    }

    @Override
    public IModuleProxy getModuleProxy(IModule module) {
        return this.getModuleProxy(module.getClientProxyPath());
    }

    @Override
    public String getFileContents(ResourceLocation location) {
        location = new ResourceLocation(location.func_110624_b(), "templates/" + location.func_110623_a() + ".json");
        IResource resource = ClientHelper.getResource(location);
        String fileContents = "";
        if (resource != null) {
            InputStream inputStream = resource.func_110527_b();
            try {
                fileContents = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                this.getMod().getLogger().getLogger().error("Failed to get File: " + location + " Exception: " + e);
            }
        }
        return fileContents;
    }

    @Override
    public void createResourceLoader(String modid) {
        if (resourceLoader == null) {
            resourceLoader = new ResourceLoader();
            try {
                resourceLoader.setup();
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.getMod().getLogger().getLogger().error((Object)e);
            }
        }
        resourceLoader.createImportantFolders(modid);
    }

    @Override
    public void handleSounds() {
        Optional.ofNullable(resourceLoader).ifPresent(loader -> loader.handleSoundsJsonForMod(this.getMod()));
    }

    private ModelHandler getModelHandler() {
        if (this.modelHandler == null) {
            this.modelHandler = new ModelHandler(this.getMod());
        }
        return this.modelHandler;
    }

    @Override
    public void loadEntityRenderers(ASMDataTable table, ModuleHandler moduleHandler) {
        EntityRendererLoader.loadRenderersFor(table, moduleHandler);
    }

    @Override
    public World getWorld(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

