/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.reinforcement;

import com.blakebr0.pickletweaks.config.ModConfig;
import com.blakebr0.pickletweaks.feature.reinforcement.ReinforcementBlacklist;
import com.blakebr0.pickletweaks.feature.reinforcement.ReinforcementHelper;
import com.blakebr0.pickletweaks.tweaks.TweakToolBreaking;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ReinforcementRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public ReinforcementRecipe() {
        this.setRegistryName("pickletweaks", "reinforcement");
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return !this.getReinforcementOutput(inv).func_190926_b();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getReinforcementOutput(inv);
    }

    public ItemStack getReinforcementOutput(InventoryCrafting inv) {
        ItemStack tool = ItemStack.field_190927_a;
        boolean foundTool = false;
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            if (slotStack.func_190926_b()) continue;
            ItemStack newSlotStack = slotStack.func_77946_l();
            newSlotStack.func_190920_e(1);
            if (!foundTool && newSlotStack.func_77984_f()) {
                tool = newSlotStack;
                foundTool = true;
                continue;
            }
            inputs.add((Object)newSlotStack);
        }
        if (tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (inputs.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (tool.func_77973_b().hasContainerItem(tool)) {
            return ItemStack.field_190927_a;
        }
        if (ModConfig.confBrokenTools && TweakToolBreaking.isBroken(tool, tool.func_77973_b() instanceof ItemSword ? 1 : 0)) {
            return ItemStack.field_190927_a;
        }
        if (ReinforcementBlacklist.isBlacklisted(tool.func_77973_b())) {
            return ItemStack.field_190927_a;
        }
        int reeCount = 0;
        boolean maxed = false;
        int currentCount = ReinforcementHelper.getReinforcement(tool);
        for (ItemStack mat : inputs) {
            if (maxed) {
                return ItemStack.field_190927_a;
            }
            if (ReinforcementHelper.isReinforcement(mat)) {
                if ((reeCount += ReinforcementHelper.getReinforcementValue(mat)) + currentCount <= ModConfig.confMaxReinforcement) continue;
                maxed = true;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (reeCount == 0) {
            return ItemStack.field_190927_a;
        }
        ReinforcementHelper.reinforce(tool, reeCount);
        return tool;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }
}

