/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tile;

import com.blakebr0.cucumber.energy.EnergyStorageCustom;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.cucumber.util.VanillaPacketDispatcher;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableCrafting;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeManager;
import com.blakebr0.extendedcrafting.lib.EmptyContainer;
import com.blakebr0.extendedcrafting.lib.FakeRecipeHandler;
import com.blakebr0.extendedcrafting.lib.IExtendedTable;
import com.blakebr0.extendedcrafting.tile.TileAdvancedCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileBasicCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileEliteCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileEnderCrafter;
import com.blakebr0.extendedcrafting.tile.TileUltimateCraftingTable;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileAutomationInterface
extends TileEntity
implements ITickable,
ISidedInventory {
    private final ItemStackHandler inventory = new StackHandler(2);
    private final ItemStackHandler recipe = new FakeRecipeHandler();
    private final EnergyStorageCustom energy = new EnergyStorageCustom(ModConfig.confInterfaceRFCapacity);
    private int oldEnergy;
    private ItemStack result = ItemStack.field_190927_a;
    private boolean hasRecipe = false;
    private int recipeSize;
    private int autoInsert = -1;
    private int autoExtract = -1;
    private boolean autoEject = false;
    private boolean smartInsert = true;
    private int ticks = 0;

    public void func_73660_a() {
        boolean mark = false;
        ++this.ticks;
        if (!this.func_145831_w().field_72995_K) {
            ItemStack toInsert;
            ItemStack stack;
            int i;
            IItemHandler handler;
            TileEntity tile;
            ItemStack input = this.getInventory().getStackInSlot(0);
            ItemStack output = this.getInventory().getStackInSlot(1);
            boolean hasTable = this.hasTable();
            if (!input.func_190926_b() && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate) {
                this.handleInput(input, hasTable && this.hasRecipe());
            }
            if (hasTable && this.hasRecipe() && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate && this.ticks % 10 == 0) {
                this.handleOutput(output);
            }
            if (this.getInserterFace() != null && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate && this.ticks % 4 == 0 && (tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.getInserterFace()))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                for (i = 0; i < handler.getSlots(); ++i) {
                    stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b() || !this.checkStackSmartly(toInsert = StackHelper.withSize((ItemStack)stack.func_77946_l(), (int)1, (boolean)false)) || !input.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)input, (ItemStack)toInsert)) continue;
                    this.getInventory().insertItem(0, toInsert, false);
                    handler.extractItem(i, 1, false);
                    this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
                    break;
                }
            }
            if (this.getExtractorFace() != null && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate && this.ticks % 4 == 0 && (tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(this.getExtractorFace()))) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                for (i = 0; i < handler.getSlots(); ++i) {
                    stack = handler.getStackInSlot(i);
                    if (output.func_190926_b()) continue;
                    toInsert = StackHelper.withSize((ItemStack)output.func_77946_l(), (int)1, (boolean)false);
                    if (!stack.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)stack, (ItemStack)toInsert)) continue;
                    handler.insertItem(i, toInsert, false);
                    output.func_190918_g(1);
                    this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
                    break;
                }
            }
        }
        if (this.oldEnergy != this.energy.getEnergyStored()) {
            this.oldEnergy = this.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (this.ticks > 100) {
            this.ticks = 0;
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    private void handleInput(ItemStack input, boolean canInsert) {
        ItemStack output = this.getInventory().getStackInSlot(1);
        ItemStack toInsert = StackHelper.withSize((ItemStack)input.func_77946_l(), (int)1, (boolean)false);
        IExtendedTable table = null;
        IInventory matrix = null;
        int slotToPut = -1;
        if (canInsert) {
            table = this.getTable();
            ItemStackHandler recipe = this.getRecipe();
            matrix = (IInventory)table;
            ItemStack stackToPut = ItemStack.field_190927_a;
            for (int i = 0; i < matrix.func_70302_i_(); ++i) {
                ItemStack slot = matrix.func_70301_a(i);
                ItemStack recipeStack = recipe.getStackInSlot(i);
                if (!slot.func_190926_b() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.func_190926_b() && slot.func_190916_E() >= slot.func_77976_d()) continue;
                if (slot.func_190926_b()) {
                    slotToPut = i;
                    break;
                }
                if (!stackToPut.func_190926_b() && (stackToPut.func_190926_b() || slot.func_190916_E() >= stackToPut.func_190916_E())) continue;
                slotToPut = i;
                stackToPut = slot.func_77946_l();
            }
        }
        if (matrix != null && slotToPut > -1) {
            this.insertItem(matrix, slotToPut, toInsert);
            input.func_190918_g(1);
            if (this.isCraftingTable()) {
                table.setResult(TableRecipeManager.getInstance().findMatchingRecipe(new TableCrafting(new EmptyContainer(), table), this.func_145831_w()));
            }
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        } else if (this.getAutoEject() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)toInsert))) {
            this.getInventory().insertItem(1, toInsert, false);
            input.func_190918_g(1);
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        }
    }

    public void handleOutput(ItemStack output) {
        IExtendedTable table = this.getTable();
        ItemStack result = table.getResult();
        IInventory matrix = (IInventory)table;
        if (!result.func_190926_b() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)result)) && this.getEnergy().getEnergyStored() >= ModConfig.confInterfaceRFRate) {
            ItemStack toInsert = result.func_77946_l();
            if (this.isEnderCrafter()) {
                table.setResult(ItemStack.field_190927_a);
            } else {
                ItemStack slotStack;
                int i;
                for (i = 0; i < matrix.func_70302_i_(); ++i) {
                    slotStack = matrix.func_70301_a(i);
                    ItemStack recipeStack = this.getRecipe().getStackInSlot(i);
                    if (recipeStack.func_190926_b() || !slotStack.func_190926_b() && StackHelper.areStacksEqual((ItemStack)recipeStack, (ItemStack)slotStack)) continue;
                    return;
                }
                for (i = 0; i < matrix.func_70302_i_(); ++i) {
                    slotStack = matrix.func_70301_a(i);
                    if (slotStack.func_190926_b()) continue;
                    if (slotStack.func_77973_b().hasContainerItem(slotStack) && slotStack.func_190916_E() == 1) {
                        matrix.func_70299_a(i, slotStack.func_77973_b().getContainerItem(slotStack));
                        continue;
                    }
                    matrix.func_70298_a(i, 1);
                }
                table.setResult(TableRecipeManager.getInstance().findMatchingRecipe(new TableCrafting(new EmptyContainer(), table), this.func_145831_w()));
            }
            this.getInventory().insertItem(1, toInsert, false);
            this.getEnergy().extractEnergy(ModConfig.confInterfaceRFRate, false);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_179237_a(this.inventory.serializeNBT());
        tag.func_179237_a(this.recipe.serializeNBT());
        tag.func_74768_a("RecipeSize", this.recipeSize);
        tag.func_74768_a("Energy", this.energy.getEnergyStored());
        tag.func_74782_a("Result", (NBTBase)this.result.serializeNBT());
        tag.func_74757_a("HasRecipe", this.hasRecipe);
        tag.func_74768_a("AutoInsert", this.autoInsert);
        tag.func_74768_a("AutoExtract", this.autoExtract);
        tag.func_74757_a("AutoEject", this.autoEject);
        tag.func_74757_a("SmartInsert", this.smartInsert);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag);
        this.recipe.deserializeNBT(tag);
        this.recipeSize = tag.func_74762_e("RecipeSize");
        this.energy.setEnergy(tag.func_74762_e("Energy"));
        this.result = new ItemStack(tag.func_74775_l("Result"));
        this.hasRecipe = tag.func_74767_n("HasRecipe");
        this.autoInsert = tag.func_74762_e("AutoInsert");
        this.autoExtract = tag.func_74762_e("AutoExtract");
        this.autoEject = tag.func_74767_n("AutoEject");
        this.smartInsert = tag.func_74767_n("SmartInsert");
        if (this.recipeSize == 0) {
            this.recipeSize = (int)Math.sqrt(this.recipe.getSlots());
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public int func_70302_i_() {
        return this.inventory.getSlots();
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return index >= 0 && index < this.inventory.getSlots() && !this.inventory.getStackInSlot(index).func_190926_b() && count > 0 ? this.inventory.getStackInSlot(index).func_77979_a(count) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index >= 0 && index < this.inventory.getSlots()) {
            this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = this.inventory.getStackInSlot(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.setStackInSlot(index, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUseableByPlayer(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, side);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return (T)super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public ItemStackHandler getRecipe() {
        return this.recipe;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public EnergyStorageCustom getEnergy() {
        return this.energy;
    }

    public IExtendedTable getTable() {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        return tile != null && tile instanceof IExtendedTable ? (IExtendedTable)tile : null;
    }

    public boolean hasTable() {
        IExtendedTable table = this.getTable();
        return table != null && (!this.hasRecipe() || table.getLineSize() == this.recipeSize);
    }

    public boolean isEnderCrafter() {
        return this.getTable() instanceof TileEnderCrafter;
    }

    public boolean isCraftingTable() {
        IExtendedTable table = this.getTable();
        return table instanceof TileBasicCraftingTable || table instanceof TileAdvancedCraftingTable || table instanceof TileEliteCraftingTable || table instanceof TileUltimateCraftingTable;
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setHasRecipe(boolean hasRecipe) {
        this.hasRecipe = hasRecipe;
    }

    public void saveRecipe() {
        ItemStackHandler recipe = this.getRecipe();
        IExtendedTable table = this.getTable();
        NonNullList<ItemStack> matrix = table.getMatrix();
        recipe.setSize(matrix.size());
        for (int i = 0; i < matrix.size(); ++i) {
            recipe.setStackInSlot(i, ((ItemStack)matrix.get(i)).func_77946_l());
        }
        if (this.isEnderCrafter()) {
            this.result = EnderCrafterRecipeManager.getInstance().findMatchingRecipe(new TableCrafting(new EmptyContainer(), table), this.func_145831_w());
        } else {
            ItemStack result = table.getResult();
            if (result != null) {
                this.result = result;
            }
        }
        this.setHasRecipe(true);
        this.recipeSize = table.getLineSize();
        this.func_70296_d();
    }

    public void clearRecipe() {
        ItemStackHandler recipe = this.getRecipe();
        recipe.setSize(1);
        this.result = ItemStack.field_190927_a;
        this.setHasRecipe(false);
        this.func_70296_d();
    }

    public EnumFacing getInserterFace() {
        return this.autoInsert > -1 && this.autoInsert < EnumFacing.values().length ? EnumFacing.values()[this.autoInsert] : null;
    }

    public EnumFacing getExtractorFace() {
        return this.autoExtract > -1 && this.autoExtract < EnumFacing.values().length ? EnumFacing.values()[this.autoExtract] : null;
    }

    public String getInserterFaceName() {
        return this.getInserterFace() != null ? this.getInserterFace().func_176610_l().toUpperCase(Locale.ROOT) : Utils.localize((String)"ec.interface.none");
    }

    public String getExtractorFaceName() {
        return this.getExtractorFace() != null ? this.getExtractorFace().func_176610_l().toUpperCase(Locale.ROOT) : Utils.localize((String)"ec.interface.none");
    }

    public void switchInserter() {
        if (this.autoInsert >= EnumFacing.values().length - 1) {
            this.autoInsert = -1;
        } else {
            ++this.autoInsert;
            if (this.autoInsert == EnumFacing.DOWN.func_176745_a()) {
                ++this.autoInsert;
            }
        }
        this.func_70296_d();
    }

    public void switchExtractor() {
        if (this.autoExtract >= EnumFacing.values().length - 1) {
            this.autoExtract = -1;
        } else {
            ++this.autoExtract;
            if (this.autoExtract == EnumFacing.DOWN.func_176745_a()) {
                ++this.autoExtract;
            }
        }
        this.func_70296_d();
    }

    public void disableInserter() {
        if (this.autoInsert != -1) {
            this.autoInsert = -1;
            this.func_70296_d();
        }
    }

    public void disableExtractor() {
        if (this.autoExtract != -1) {
            this.autoExtract = -1;
            this.func_70296_d();
        }
    }

    public boolean checkStackSmartly(ItemStack stack) {
        if (!this.getSmartInsert()) {
            return true;
        }
        if (!this.hasTable()) {
            return false;
        }
        if (!this.hasRecipe()) {
            return false;
        }
        NonNullList<ItemStack> matrix = this.getTable().getMatrix();
        for (int i = 0; i < matrix.size(); ++i) {
            ItemStack slotStack = (ItemStack)matrix.get(i);
            ItemStack recipeStack = this.getRecipe().getStackInSlot(i);
            if (!StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)recipeStack) || !slotStack.func_190926_b() && !StackHelper.canCombineStacks((ItemStack)stack, (ItemStack)slotStack)) continue;
            return true;
        }
        return false;
    }

    public boolean getAutoEject() {
        return this.autoEject;
    }

    public void toggleAutoEject() {
        this.autoEject = !this.autoEject;
        this.func_70296_d();
    }

    public boolean getSmartInsert() {
        return this.smartInsert;
    }

    public void toggleSmartInsert() {
        this.smartInsert = !this.smartInsert;
        this.func_70296_d();
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    private int insertItem(IInventory matrix, int slot, ItemStack stack) {
        ItemStack slotStack = matrix.func_70301_a(slot);
        if (slotStack.func_190926_b()) {
            matrix.func_70299_a(slot, stack);
            return stack.func_190916_E();
        }
        if (StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)slotStack) && slotStack.func_190916_E() < slotStack.func_77976_d()) {
            ItemStack newStack = slotStack.func_77946_l();
            int newSize = Math.min(slotStack.func_190916_E() + stack.func_190916_E(), slotStack.func_77976_d());
            newStack.func_190920_e(newSize);
            matrix.func_70299_a(slot, newStack);
            return newSize - slotStack.func_190916_E();
        }
        return 0;
    }

    class StackHandler
    extends ItemStackHandler {
        StackHandler(int size) {
            super(size);
        }

        public void onContentsChanged(int slot) {
            TileAutomationInterface.this.func_70296_d();
        }
    }
}

