/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.gui.automationinterface;

import com.blakebr0.cucumber.gui.button.IconButton;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.client.gui.automationinterface.GuiAutomationInterface;
import com.blakebr0.extendedcrafting.network.InterfaceAutoChangePacket;
import com.blakebr0.extendedcrafting.network.NetworkThingy;
import com.blakebr0.extendedcrafting.tile.TileAutomationInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiInterfaceConfig
extends GuiContainer {
    private GuiAutomationInterface parent;
    private TileAutomationInterface tile;
    public DirButton insert;
    public DirButton extract;
    public CheckboxButton eject;
    public CheckboxButton smart;
    public GuiButton back;

    public GuiInterfaceConfig(GuiAutomationInterface parent) {
        super(parent.field_147002_h);
        this.parent = parent;
        this.tile = parent.tile;
        this.field_146999_f = parent.getXSize();
        this.field_147000_g = parent.getYSize();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (mouseX > this.field_147003_i + 7 && mouseX < this.field_147003_i + 20 && mouseY > this.field_147009_r + 16 && mouseY < this.field_147009_r + 93) {
            this.func_146279_a(Utils.format((Object)this.tile.getEnergy().getEnergyStored()) + " FE", mouseX, mouseY);
        }
        if (this.back.func_146115_a()) {
            this.func_146279_a(this.back.field_146126_j, mouseX, mouseY);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a()) continue;
            if (button instanceof DirButton) {
                this.func_146283_a(((DirButton)button).tooltip, mouseX, mouseY);
                continue;
            }
            if (!(button instanceof CheckboxButton)) continue;
            this.func_146283_a(((CheckboxButton)button).tooltip, mouseX, mouseY);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.insert = (DirButton)this.func_189646_b(new DirButton(0, x + 63, y + 20, Utils.localize((String)"ec.interface.auto_insert")));
        this.extract = (DirButton)this.func_189646_b(new DirButton(1, x + 63, y + 33, Utils.localize((String)"ec.interface.auto_extract")));
        this.eject = (CheckboxButton)this.func_189646_b(new CheckboxButton(2, x + 63, y + 46, Utils.localize((String)"ec.interface.auto_eject")));
        this.smart = (CheckboxButton)this.func_189646_b(new CheckboxButton(3, x + 63, y + 59, Utils.localize((String)"ec.interface.smart_insert")));
        this.back = this.func_189646_b((GuiButton)new IconButton(10, x + 82, y + 74, 29, 15, 71, 210, Utils.localize((String)"ec.interface.back"), GuiAutomationInterface.GUI));
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.back) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        } else if (button == this.insert) {
            if (Utils.isShiftKeyDown()) {
                NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 4));
                this.insert.facing = null;
            } else {
                NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 0));
                this.insert.facing = this.incrementFace(this.insert.facing);
            }
            this.insert.tooltip = this.getButtonTooltip(this.insert);
        } else if (button == this.extract) {
            if (Utils.isShiftKeyDown()) {
                NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 5));
                this.extract.facing = null;
            } else {
                NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 1));
                this.extract.facing = this.incrementFace(this.extract.facing);
            }
            this.extract.tooltip = this.getButtonTooltip(this.extract);
        } else if (button == this.eject) {
            NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 2));
            this.eject.on = !this.eject.on;
            this.eject.tooltip = this.getButtonTooltip(this.eject);
        } else if (button == this.smart) {
            NetworkThingy.THINGY.sendToServer((IMessage)new InterfaceAutoChangePacket(this.tile.func_174877_v(), 3));
            this.smart.on = !this.smart.on;
            this.smart.tooltip = this.getButtonTooltip(this.smart);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = Utils.localize((String)"container.ec.interface");
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(Utils.localize((String)"container.inventory"), 8, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GuiAutomationInterface.GUI);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int i1 = this.parent.getEnergyBarScaled(78);
        this.func_73729_b(x + 7, y + 94 - i1, 178, 78 - i1, 15, i1 + 1);
    }

    public void updateButtons() {
        this.insert.facing = this.tile.getInserterFace();
        this.extract.facing = this.tile.getExtractorFace();
        this.eject.on = this.tile.getAutoEject();
        this.smart.on = this.tile.getSmartInsert();
        this.insert.tooltip = this.getButtonTooltip(this.insert);
        this.extract.tooltip = this.getButtonTooltip(this.extract);
        this.eject.tooltip = this.getButtonTooltip(this.eject);
        this.smart.tooltip = this.getButtonTooltip(this.smart);
    }

    private List<String> getButtonTooltip(GuiButton button) {
        ArrayList<String> list = new ArrayList<String>();
        if (button instanceof DirButton) {
            EnumFacing facing = ((DirButton)button).facing;
            if (facing == null || facing == EnumFacing.DOWN) {
                list.add(button.field_146126_j + " -> " + "\u00a7c" + Utils.localize((String)"ec.interface.none"));
            } else {
                list.add(button.field_146126_j + " -> " + "\u00a7e" + facing.func_176610_l().toUpperCase(Locale.ROOT));
            }
            if (button == this.insert) {
                list.addAll(this.field_146289_q.func_78271_c("\u00a77" + Utils.localize((String)"ec.interface.insert_desc"), 200));
            }
            if (button == this.extract) {
                list.addAll(this.field_146289_q.func_78271_c("\u00a77" + Utils.localize((String)"ec.interface.extract_desc"), 200));
            }
        } else if (button instanceof CheckboxButton) {
            if (((CheckboxButton)button).on) {
                list.add(button.field_146126_j + " -> " + "\u00a7a" + Utils.localize((String)"ec.interface.on"));
            } else {
                list.add(button.field_146126_j + " -> " + "\u00a7c" + Utils.localize((String)"ec.interface.off"));
            }
            if (button == this.eject) {
                list.addAll(this.field_146289_q.func_78271_c("\u00a77" + Utils.localize((String)"ec.interface.eject_desc"), 200));
            }
            if (button == this.smart) {
                list.addAll(this.field_146289_q.func_78271_c("\u00a77" + Utils.localize((String)"ec.interface.smart_desc"), 200));
            }
        }
        return list;
    }

    private EnumFacing incrementFace(EnumFacing facing) {
        if (facing == null) {
            return EnumFacing.UP;
        }
        int index = facing.func_176745_a() + 1;
        if (index > EnumFacing.values().length - 1) {
            return null;
        }
        return EnumFacing.values()[index];
    }

    public class DirButton
    extends GuiButton {
        public EnumFacing facing;
        public List<String> tooltip;

        public DirButton(int id, int x, int y, String text) {
            super(id, x, y, 68, 11, text);
            this.facing = null;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(GuiAutomationInterface.GUI);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 72, 197, this.field_146120_f, this.field_146121_g);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 155 + 11 * this.getIndex(this.facing), 197, 11, 11);
                this.func_146119_b(mc, mouseX, mouseY);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)1.0);
                fontrenderer.func_78276_b(this.field_146126_j, (int)((double)(this.field_146128_h + 12) / 0.85), (int)((double)(this.field_146129_i + (this.field_146121_g - 9) / 2 + 2) / 0.85), 0x404040);
                GlStateManager.func_179121_F();
            }
        }

        private int getIndex(EnumFacing facing) {
            if (facing == null) {
                return 0;
            }
            return facing.func_176745_a();
        }
    }

    public class CheckboxButton
    extends GuiButton {
        public List<String> tooltip;
        public boolean on;

        public CheckboxButton(int id, int x, int y, String text) {
            super(id, x, y, 68, 11, text);
            this.on = true;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                FontRenderer fontrenderer = mc.field_71466_p;
                mc.func_110434_K().func_110577_a(GuiAutomationInterface.GUI);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = this.func_146114_a(this.field_146123_n);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 72, 197, this.field_146120_f, this.field_146121_g);
                if (this.on) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i, 142, 197, 11, 11);
                }
                this.func_146119_b(mc, mouseX, mouseY);
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.85, (double)0.85, (double)1.0);
                fontrenderer.func_78276_b(this.field_146126_j, (int)((double)(this.field_146128_h + 12) / 0.85), (int)((double)(this.field_146129_i + (this.field_146121_g - 9) / 2 + 2) / 0.85), 0x404040);
                GlStateManager.func_179121_F();
            }
        }
    }
}

