/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;

public class StructureHelper {
    public static final StructureHelper CACHE = new StructureHelper();
    private final Map<StructureCacheEntry, Boolean> structureCache = new HashMap<StructureCacheEntry, Boolean>();

    public void clear() {
        this.structureCache.clear();
    }

    public boolean isInStructure(World world, String structure, BlockPos pos) {
        int dimension = world.field_73011_w.getDimension();
        ChunkPos cp = new ChunkPos(pos);
        long cplong = ChunkPos.func_77272_a((int)cp.field_77276_a, (int)cp.field_77275_b);
        StructureCacheEntry entry = new StructureCacheEntry(structure, dimension, cplong);
        if (this.structureCache.containsKey(entry)) {
            return this.structureCache.get(entry);
        }
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, structure);
        if (data == null) {
            return false;
        }
        Set<Long> longs = StructureHelper.parseStructureData(data);
        for (Long l : longs) {
            this.structureCache.put(new StructureCacheEntry(structure, dimension, l), true);
        }
        if (this.structureCache.containsKey(entry)) {
            return true;
        }
        this.structureCache.put(entry, false);
        return false;
    }

    private static Set<Long> parseStructureData(MapGenStructureData data) {
        HashSet<Long> chunks = new HashSet<Long>();
        NBTTagCompound nbttagcompound = data.func_143041_a();
        for (String s : nbttagcompound.func_150296_c()) {
            NBTTagCompound nbttagcompound1;
            NBTBase nbtbase = nbttagcompound.func_74781_a(s);
            if (nbtbase.func_74732_a() != 10 || !(nbttagcompound1 = (NBTTagCompound)nbtbase).func_74764_b("ChunkX") || !nbttagcompound1.func_74764_b("ChunkZ")) continue;
            int i = nbttagcompound1.func_74762_e("ChunkX");
            int j = nbttagcompound1.func_74762_e("ChunkZ");
            chunks.add(ChunkPos.func_77272_a((int)i, (int)j));
        }
        return chunks;
    }

    public static class StructureCacheEntry {
        @Nonnull
        private final String structure;
        private final int dimension;
        private final long chunkpos;

        public StructureCacheEntry(@Nonnull String structure, int dimension, long chunkpos) {
            this.structure = structure;
            this.dimension = dimension;
            this.chunkpos = chunkpos;
        }

        @Nonnull
        public String getStructure() {
            return this.structure;
        }

        public int getDimension() {
            return this.dimension;
        }

        public long getChunkpos() {
            return this.chunkpos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureCacheEntry that = (StructureCacheEntry)o;
            if (this.dimension != that.dimension) {
                return false;
            }
            if (this.chunkpos != that.chunkpos) {
                return false;
            }
            return this.structure.equals(that.structure);
        }

        public int hashCode() {
            int result = this.structure.hashCode();
            result = 31 * result + this.dimension;
            result = 31 * result + (int)(this.chunkpos ^ this.chunkpos >>> 32);
            return result;
        }
    }
}

