/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import nc.config.NCConfig;
import nc.init.NCArmor;
import nc.init.NCItems;
import nc.recipe.vanilla.CraftingRecipeHandler;
import nc.util.ArmorHelper;
import nc.util.RegistryHelper;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RadiationArmor {
    public static final Set<ItemStack> ARMOR_STACK_SHIELDING_BLACKLIST = new HashSet<ItemStack>();
    public static final Set<ItemStack> ARMOR_STACK_SHIELDING_LIST = new HashSet<ItemStack>();
    public static final Int2DoubleMap ARMOR_RAD_RESISTANCE_MAP = new Int2DoubleOpenHashMap();

    public static void init() {
        ItemStack stack;
        ARMOR_STACK_SHIELDING_BLACKLIST.add(new ItemStack((Item)NCArmor.helm_hazmat));
        ARMOR_STACK_SHIELDING_BLACKLIST.add(new ItemStack((Item)NCArmor.chest_hazmat));
        ARMOR_STACK_SHIELDING_BLACKLIST.add(new ItemStack((Item)NCArmor.legs_hazmat));
        ARMOR_STACK_SHIELDING_BLACKLIST.add(new ItemStack((Item)NCArmor.boots_hazmat));
        for (String stackInfo : NCConfig.radiation_shielding_item_blacklist) {
            stack = RegistryHelper.itemStackFromRegistry(stackInfo);
            if (stack == null) continue;
            ARMOR_STACK_SHIELDING_BLACKLIST.add(stack);
        }
        for (String stackInfo : NCConfig.radiation_shielding_custom_stacks) {
            stack = RegistryHelper.itemStackFromRegistry(stackInfo);
            if (stack == null) continue;
            ARMOR_STACK_SHIELDING_LIST.add(stack);
        }
    }

    public static void postInit() {
        for (String stackInfo : NCConfig.radiation_shielding_default_levels) {
            int scorePos = stackInfo.lastIndexOf(95);
            if (scorePos == -1) continue;
            ItemStack stack = RegistryHelper.itemStackFromRegistry(stackInfo.substring(0, scorePos));
            if (stack == null || stack.func_190926_b() || !ArmorHelper.isArmor(stack.func_77973_b(), NCConfig.radiation_horse_armor_public)) {
                return;
            }
            int packed = RecipeItemHelper.func_194113_b((ItemStack)stack);
            if (packed == 0) {
                return;
            }
            ARMOR_RAD_RESISTANCE_MAP.put(packed, Double.parseDouble(stackInfo.substring(scorePos + 1)));
        }
    }

    public static void refreshRadiationArmor() {
        ARMOR_RAD_RESISTANCE_MAP.clear();
        RadiationArmor.postInit();
    }

    public static ItemStack armorWithRadResistance(ItemStack armor, double resistance) {
        ItemStack stack = armor.func_77946_l();
        if (!ArmorHelper.isArmor(armor.func_77973_b(), true)) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74780_a("ncRadiationResistance", resistance);
        return stack;
    }

    public static void addArmorShieldingRecipes(ItemStack stack) {
        CraftingRecipeHandler.addShapelessArmorUpgradeRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[0]), stack, new ItemStack(NCItems.rad_shielding, 1, 0));
        CraftingRecipeHandler.addShapelessArmorUpgradeRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[1]), stack, new ItemStack(NCItems.rad_shielding, 1, 1));
        CraftingRecipeHandler.addShapelessArmorUpgradeRecipe(RadiationArmor.armorWithRadResistance(stack, NCConfig.radiation_shielding_level[2]), stack, new ItemStack(NCItems.rad_shielding, 1, 2));
    }
}

