/*
 * Decompiled with CFR 0.152.
 */
package nc.handler;

import java.util.List;
import java.util.Set;
import nc.NCInfo;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import nc.util.ArmorHelper;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipHandler {
    private static final String RADIATION = Lang.localise("item.nuclearcraft.rads");
    private static final String RADIATION_RESISTANCE = Lang.localise("item.nuclearcraft.rad_resist");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addAdditionalTooltips(ItemTooltipEvent event) {
        Set<String> oreNames;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        if (!stack.func_77973_b().getRegistryName().func_110624_b().equals("nuclearcraft") && !(oreNames = OreDictHelper.getOreNames(stack)).isEmpty()) {
            if (oreNames.contains("blockGraphite")) {
                InfoHelper.infoFull(event.getToolTip(), TextFormatting.AQUA, NCInfo.ingotBlockFixedInfo()[8], NCInfo.ingotBlockInfo()[8]);
            } else if (oreNames.contains("blockBeryllium")) {
                InfoHelper.infoFull(event.getToolTip(), TextFormatting.AQUA, NCInfo.ingotBlockFixedInfo()[9], NCInfo.ingotBlockInfo()[9]);
            }
        }
        if (NCConfig.radiation_enabled_public) {
            TooltipHandler.addArmorRadiationTooltip(event.getToolTip(), stack);
            TooltipHandler.addRadiationTooltip(event.getToolTip(), stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addRadiationTooltip(List<String> tooltip, ItemStack stack) {
        if (!stack.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource stackRadiation = (IRadiationSource)stack.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (stackRadiation == null || stackRadiation.getRadiationLevel() <= 0.0) {
            return;
        }
        tooltip.add(RadiationHelper.getRadiationTextColor(stackRadiation.getRadiationLevel() * (double)stack.func_190916_E()) + RADIATION + " " + RadiationHelper.radsPrefix(stackRadiation.getRadiationLevel() * (double)stack.func_190916_E(), true));
    }

    @SideOnly(value=Side.CLIENT)
    private static void addArmorRadiationTooltip(List<String> tooltip, ItemStack stack) {
        IRadiationResistance armorResistance;
        boolean nbt;
        if (!ArmorHelper.isArmor(stack.func_77973_b(), NCConfig.radiation_horse_armor_public)) {
            return;
        }
        boolean capability = stack.hasCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        boolean bl = nbt = stack.func_77942_o() && stack.func_77978_p().func_74764_b("ncRadiationResistance");
        if (!capability && !nbt) {
            return;
        }
        double resistance = 0.0;
        if (capability && (armorResistance = (IRadiationResistance)stack.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null)) != null) {
            resistance += armorResistance.getRadiationResistance();
        }
        if (nbt) {
            resistance += stack.func_77978_p().func_74769_h("ncRadiationResistance");
        }
        if (resistance > 0.0) {
            tooltip.add(TextFormatting.AQUA + RADIATION_RESISTANCE + " " + resistance);
        }
    }
}

