/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile.generator;

import javax.annotation.Nullable;
import nc.NuclearCraft;
import nc.block.tile.BlockInventory;
import nc.block.tile.generator.BlockFusionCore;
import nc.config.NCConfig;
import nc.enumm.BlockEnums;
import nc.init.NCBlocks;
import nc.tile.generator.TileFusionCore;
import nc.util.BlockPosHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFusionDummy
extends BlockInventory {
    private final BlockEnums.FusionDummyTileType type;

    public BlockFusionDummy(BlockEnums.FusionDummyTileType type) {
        super(type.func_176610_l(), Material.field_151573_f);
        this.type = type;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return this.type.getTile();
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        if (this.findCore(world, pos) != null) {
            world.func_175655_b(this.findCore(world, pos), true);
        }
        if (world.func_175625_s(pos) != null) {
            world.func_175713_t(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        BlockPos corePos;
        if (world.field_72995_K) {
            return true;
        }
        if (player != null && (corePos = this.findCore(world, pos)) != null && (tileentity = world.func_175625_s(corePos)) instanceof TileFusionCore) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)101, (World)world, (int)corePos.func_177958_n(), (int)corePos.func_177956_o(), (int)corePos.func_177952_p());
        }
        return true;
    }

    public BlockPos findCore(World world, BlockPos pos) {
        BlockPosHelper helper = new BlockPosHelper(pos);
        for (BlockPos blockPos : helper.cuboid(this.type.getCoords()[0], this.type.getCoords()[1], this.type.getCoords()[2], this.type.getCoords()[3], this.type.getCoords()[4], this.type.getCoords()[5])) {
            if (!this.isCore(world, blockPos)) continue;
            return blockPos;
        }
        return null;
    }

    private boolean isCore(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockFusionCore;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        BlockPos position = this.findCore(world, pos);
        if (position == null) {
            return 0;
        }
        TileEntity tile = world.func_175625_s(position);
        if (tile != null && tile instanceof TileFusionCore) {
            return (int)MathHelper.func_151237_a((double)(15.0 * ((TileFusionCore)tile).efficiency / (double)NCConfig.fusion_comparator_max_efficiency), (double)0.0, (double)15.0);
        }
        return Container.func_178144_a((TileEntity)world.func_175625_s(position));
    }

    public ItemStack getItem(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(NCBlocks.fusion_core);
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)NCBlocks.fusion_core));
        player.func_71020_j(0.005f);
    }
}

