/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile;

import javax.annotation.Nullable;
import nc.NuclearCraft;
import nc.block.NCBlock;
import nc.init.NCItems;
import nc.tile.IGui;
import nc.tile.fluid.ITileFluid;
import nc.tile.processor.IProcessor;
import nc.tile.processor.IUpgradable;
import nc.util.FluidHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BlockTile
extends NCBlock
implements ITileEntityProvider {
    public BlockTile(String name, Material material) {
        super(name, material);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || hand != EnumHand.MAIN_HAND) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IUpgradable) {
            if (this.installUpgrade(tile, ((IUpgradable)tile).getSpeedUpgradeSlot(), player, facing, new ItemStack(NCItems.upgrade, 1, 0))) {
                return true;
            }
            if (this.installUpgrade(tile, ((IUpgradable)tile).getEnergyUpgradeSlot(), player, facing, new ItemStack(NCItems.upgrade, 1, 1))) {
                return true;
            }
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!(tile instanceof ITileFluid) && !(tile instanceof IGui)) {
            return false;
        }
        if (tile instanceof ITileFluid && !(tile instanceof IGui) && FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) == null) {
            return false;
        }
        if (tile instanceof ITileFluid) {
            if (world.field_72995_K) {
                return true;
            }
            ITileFluid tileFluid = (ITileFluid)tile;
            boolean accessedTanks = FluidHelper.accessTanks(player, hand, facing, tileFluid);
            if (accessedTanks) {
                if (tile instanceof IProcessor) {
                    ((IProcessor)tile).refreshRecipe();
                    ((IProcessor)tile).refreshActivity();
                }
                return true;
            }
        }
        if (tile instanceof IGui) {
            if (world.field_72995_K) {
                this.onGuiOpened(world, pos);
                return true;
            }
            this.onGuiOpened(world, pos);
            if (tile instanceof IProcessor) {
                ((IProcessor)tile).refreshRecipe();
                ((IProcessor)tile).refreshActivity();
            }
        } else {
            return false;
        }
        FMLNetworkHandler.openGui((EntityPlayer)player, (Object)NuclearCraft.instance, (int)((IGui)tile).getGuiID(), (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        return true;
    }

    protected boolean installUpgrade(TileEntity tile, int slot, EntityPlayer player, EnumFacing facing, ItemStack stack) {
        IItemHandler inv;
        if (player.func_184614_ca().func_77969_a(stack) && (inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) != null && inv.isItemValid(slot, player.func_184614_ca())) {
            if (player.func_70093_af()) {
                player.func_184611_a(EnumHand.MAIN_HAND, inv.insertItem(slot, player.func_184614_ca(), false));
                return true;
            }
            if (inv.insertItem(slot, stack, false).func_190926_b()) {
                player.func_184614_ca().func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    public void onGuiOpened(World world, BlockPos pos) {
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = world.func_175625_s(pos)) instanceof IInventory) {
            this.dropItems(world, pos, (IInventory)tileentity);
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public void dropItems(World world, BlockPos pos, IInventory tileentity) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

