/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.platform;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import io.github.lxgaming.sledgehammer.manager.IntegrationManager;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SledgehammerPlatform.class}, priority=1337, remap=false)
public abstract class MixinSledgehammerPlatform_Mod {
    @Shadow
    private static SledgehammerPlatform instance;

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        Sledgehammer.getInstance().getLogger().warn("Certificate Fingerprint Violation Detected!");
    }

    @Mod.EventHandler
    public void onConstruction(FMLConstructionEvent event) {
        instance = Toolbox.cast(this, SledgehammerPlatform.class);
        Sledgehammer.init();
        MappingManager.getStateMappings().put((Enum)LoaderState.CONSTRUCTING, SledgehammerPlatform.State.CONSTRUCTION);
        MappingManager.getStateMappings().put((Enum)LoaderState.PREINITIALIZATION, SledgehammerPlatform.State.PRE_INITIALIZATION);
        MappingManager.getStateMappings().put((Enum)LoaderState.INITIALIZATION, SledgehammerPlatform.State.INITIALIZATION);
        MappingManager.getStateMappings().put((Enum)LoaderState.POSTINITIALIZATION, SledgehammerPlatform.State.POST_INITIALIZATION);
        MappingManager.getStateMappings().put((Enum)LoaderState.AVAILABLE, SledgehammerPlatform.State.LOAD_COMPLETE);
        MappingManager.getStateMappings().put((Enum)LoaderState.SERVER_ABOUT_TO_START, SledgehammerPlatform.State.SERVER_ABOUT_TO_START);
        MappingManager.getStateMappings().put((Enum)LoaderState.SERVER_STARTING, SledgehammerPlatform.State.SERVER_STARTING);
        MappingManager.getStateMappings().put((Enum)LoaderState.SERVER_STARTED, SledgehammerPlatform.State.SERVER_STARTED);
        MappingManager.getStateMappings().put((Enum)LoaderState.SERVER_STOPPING, SledgehammerPlatform.State.SERVER_STOPPING);
        MappingManager.getStateMappings().put((Enum)LoaderState.SERVER_STOPPED, SledgehammerPlatform.State.SERVER_STOPPED);
        IntegrationManager.register();
        ModContainer modContainer = Loader.instance().activeModContainer();
        if (modContainer != null && StringUtils.equals((CharSequence)modContainer.getModId(), (CharSequence)"sledgehammer")) {
            modContainer.getMetadata().logoFile = "sledgehammer.png";
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandManager.register();
    }

    @Mod.EventHandler
    public void onState(FMLStateEvent event) {
        IntegrationManager.process();
    }

    @Overwrite
    public Object getContainer() {
        return Loader.instance().getIndexedModList().get("sledgehammer");
    }

    @Overwrite
    public MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    @Overwrite
    public SledgehammerPlatform.State getState() {
        return MappingManager.getStateMapping((Enum)Loader.instance().getLoaderState()).orElse(null);
    }

    @Overwrite
    public SledgehammerPlatform.Type getType() {
        return SledgehammerPlatform.Type.FORGE;
    }

    @Overwrite
    public boolean isLoaded(String id) {
        return Loader.isModLoaded((String)id);
    }
}

