/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.mixin.core.entity;

import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.category.mixin.ServerMixinCategory;
import io.github.lxgaming.sledgehammer.util.Broadcast;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ChatType;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.vehicle.minecart.Minecart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.interfaces.entity.IMixinEntity;

@Mixin(value={Entity.class}, priority=1337)
public abstract class MixinEntity_Teleport {
    @Inject(method={"setPortal"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetPortal(CallbackInfo callbackInfo) {
        if (this.sledgehammer$shouldRemove(Toolbox.cast(this, IMixinEntity.class))) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"changeDimension(I)Lnet/minecraft/entity/Entity;"}, at={@At(value="HEAD")})
    private void onChangeDimension(int dimension, CallbackInfoReturnable<Entity> callbackInfoReturnable) {
        IMixinEntity mixinEntity = Toolbox.cast(this, IMixinEntity.class);
        if (this.sledgehammer$shouldRemove(mixinEntity)) {
            mixinEntity.remove();
            Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).ifPresent(generalCategory -> {
                String message = generalCategory.getMessageCategory().getItemTeleport();
                if (StringUtils.isBlank((CharSequence)message)) {
                    return;
                }
                Broadcast broadcast = Broadcast.builder().message(Toolbox.convertColor(message.replace("[ID]", Toolbox.getRootId(Toolbox.cast(this, Entity.class))))).type(ChatType.CHAT).build();
                if (generalCategory.isDebug()) {
                    broadcast.sendMessage((ICommandSender)SledgehammerPlatform.getInstance().getServer());
                }
                mixinEntity.getCreator().flatMap(arg_0 -> ((Server)Sponge.getServer()).getPlayer(arg_0)).map(EntityPlayer.class::cast).ifPresent(broadcast::sendMessage);
            });
        }
    }

    private boolean sledgehammer$shouldRemove(IMixinEntity mixinEntity) {
        if (!(mixinEntity instanceof Item) && !(mixinEntity instanceof Minecart) || mixinEntity.isRemoved()) {
            return false;
        }
        return Sledgehammer.getInstance().getConfig().map(Config::getServerMixinCategory).map(ServerMixinCategory::getItemTeleportWhitelist).map(list -> !list.contains(Toolbox.getRootId(Toolbox.cast(this, Entity.class)))).orElse(false);
    }
}

