/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.integration;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import io.github.lxgaming.sledgehammer.Sledgehammer;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.integration.AbstractIntegration;
import io.github.lxgaming.sledgehammer.util.Broadcast;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ChatType;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeIntegration_Border
extends AbstractIntegration {
    private final Map<UUID, Long> cooldown = Maps.newHashMap();

    public SpongeIntegration_Border() {
        this.addDependency("sponge");
        this.setState(SledgehammerPlatform.State.INITIALIZATION);
    }

    @Override
    public void execute() {
        Sponge.getEventManager().registerListeners(SledgehammerPlatform.getInstance().getContainer(), (Object)this);
    }

    @Listener(order=Order.LATE)
    public void onClientConnectionDisconnect(ClientConnectionEvent.Disconnect event) {
        this.cooldown.remove(event.getTargetEntity().getUniqueId());
    }

    @Listener(order=Order.EARLY)
    public void onClientConnectionJoin(ClientConnectionEvent.Join event) {
        this.cooldown.put(event.getTargetEntity().getUniqueId(), System.currentTimeMillis());
    }

    @Listener(order=Order.LATE)
    public void onMoveEntity(MoveEntityEvent event, @Root Player player) {
        Location location = event.getToTransform().getLocation();
        World world = (World)location.getExtent();
        long radius = (long)Math.floor(world.getWorldBorder().getDiameter() / 2.0) + 1L;
        Vector3d displacement = location.getPosition().sub(world.getWorldBorder().getCenter()).abs();
        if (displacement.getX() > (double)radius || displacement.getZ() > (double)radius) {
            event.setCancelled(true);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.cooldown.getOrDefault(player.getUniqueId(), 0L) < 5000L) {
                return;
            }
            this.cooldown.put(player.getUniqueId(), currentTime);
            Sledgehammer.getInstance().getConfig().map(Config::getGeneralCategory).ifPresent(generalCategory -> {
                String message = generalCategory.getMessageCategory().getMoveOutsideBorder();
                if (StringUtils.isBlank((CharSequence)message)) {
                    return;
                }
                Broadcast broadcast = Broadcast.builder().message(Toolbox.convertColor(message)).type(ChatType.CHAT).build();
                if (generalCategory.isDebug()) {
                    broadcast.sendMessage((ICommandSender)SledgehammerPlatform.getInstance().getServer());
                }
                broadcast.sendMessage((EntityPlayer)player);
            });
        }
    }
}

