/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.command;

import com.google.common.collect.Lists;
import io.github.lxgaming.sledgehammer.command.AbstractCommand;
import io.github.lxgaming.sledgehammer.manager.CommandManager;
import io.github.lxgaming.sledgehammer.util.Text;
import io.github.lxgaming.sledgehammer.util.Toolbox;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.lang3.StringUtils;

public class HelpCommand
extends AbstractCommand {
    public HelpCommand() {
        this.addAlias("help");
        this.addAlias("?");
    }

    @Override
    public void execute(ICommandSender commandSender, List<String> arguments) {
        Optional<AbstractCommand> abstractCommand = CommandManager.getCommand(Lists.newArrayList((Object[])new String[]{"sledgehammer"}));
        if (!abstractCommand.isPresent()) {
            return;
        }
        commandSender.func_145747_a(Toolbox.getTextPrefix());
        for (AbstractCommand command : abstractCommand.get().getChildren()) {
            if (command == this || !command.checkPermission(commandSender)) continue;
            ITextComponent textComponent = Text.of("");
            textComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/sledgehammer " + command.func_71517_b()));
            textComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, this.buildDescription(command)));
            textComponent.func_150257_a(Text.of(TextFormatting.BLUE, "> ", TextFormatting.GREEN, "/sledgehammer " + command.func_71517_b()));
            if (StringUtils.isNotBlank((CharSequence)command.getUsage())) {
                textComponent.func_150257_a(Text.of(TextFormatting.GREEN, " " + command.getUsage()));
            }
            commandSender.func_145747_a(textComponent);
        }
    }

    private ITextComponent buildDescription(AbstractCommand command) {
        ITextComponent textComponent = Text.of(TextFormatting.AQUA, "Command: ", TextFormatting.DARK_GREEN, StringUtils.capitalize((String)command.func_71517_b()), Text.NEW_LINE, TextFormatting.AQUA, "Description: ", TextFormatting.DARK_GREEN, StringUtils.defaultIfBlank((CharSequence)command.getDescription(), (CharSequence)"No description provided"), Text.NEW_LINE, TextFormatting.AQUA, "Usage: ", TextFormatting.DARK_GREEN, "/sledgehammer " + command.func_71517_b());
        if (StringUtils.isNotBlank((CharSequence)command.getUsage())) {
            textComponent.func_150257_a(Text.of(TextFormatting.DARK_GREEN, " " + command.getUsage()));
        }
        textComponent.func_150257_a(Text.of(Text.NEW_LINE, TextFormatting.AQUA, "Permission: ", TextFormatting.DARK_GREEN, StringUtils.defaultIfBlank((CharSequence)command.getPermission(), (CharSequence)"None"), Text.NEW_LINE, Text.NEW_LINE, TextFormatting.GRAY, "Click to auto-complete."));
        return textComponent;
    }
}

