/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.ingredient;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesItemStackOredictionary;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;

public enum ItemMatchType {
    ITEMMETA(new FlaggedPrototypeHandler(3)),
    ITEM(new FlaggedPrototypeHandler(1)),
    ITEMMETANBT(new FlaggedPrototypeHandler(7)),
    ITEMNBT(new FlaggedPrototypeHandler(5)),
    OREDICT(itemStack -> new PrototypedIngredientAlternativesItemStackOredictionary(ItemMatchType.getOreDictKeys(itemStack), Integer.valueOf(7)));

    private static final LoadingCache<ItemStack, List<String>> CACHE_OREDICT;
    private final IPrototypeHandler prototypeHandler;

    protected static List<String> getOreDictKeys(ItemStack itemStack) {
        try {
            return (List)CACHE_OREDICT.get((Object)itemStack);
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
    }

    private ItemMatchType(IPrototypeHandler prototypeHandler) {
        this.prototypeHandler = prototypeHandler;
    }

    public ItemMatchType next() {
        ItemMatchType[] values = ItemMatchType.values();
        return this.ordinal() == values.length - 1 ? values[0] : values[this.ordinal() + 1];
    }

    public ResourceLocation getSlotSpriteName() {
        return new ResourceLocation("integrateddynamics", "slots/" + this.name().toLowerCase(Locale.ENGLISH));
    }

    public IPrototypeHandler getPrototypeHandler() {
        return this.prototypeHandler;
    }

    static {
        CACHE_OREDICT = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ItemStack, List<String>>(){

            public List<String> load(ItemStack key) {
                if (key.func_190926_b()) {
                    return Collections.emptyList();
                }
                return Arrays.stream(OreDictionary.getOreIDs((ItemStack)key)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList());
            }
        });
    }

    public static class FlaggedPrototypeHandler
    implements IPrototypeHandler {
        private final int flags;

        public FlaggedPrototypeHandler(int flags) {
            this.flags = flags;
        }

        @Override
        public IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFor(ItemStack itemStack) {
            return new PrototypedIngredientAlternativesList(ItemStackHelpers.getVariants((ItemStack)itemStack).stream().map(stack -> new PrototypedIngredient(IngredientComponent.ITEMSTACK, stack, (Object)this.flags)).collect(Collectors.toList()));
        }
    }

    public static interface IPrototypeHandler {
        public IPrototypedIngredientAlternatives<ItemStack, Integer> getPrototypesFor(ItemStack var1);
    }
}

